/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.io.file;

import io.github.astrapi69.io.file.FilenameExtensions;
import java.io.File;
import java.util.Objects;

public enum FileExtension {
    BACKUP(".bak"),
    CLASS(".class"),
    DECRYPTED(".decrypted"),
    ENCRYPTED(".enc"),
    MYSTIC_CRYPT_ENCRYPTED(".mcrdb"),
    JAVA(".java"),
    JAR(".jar"),
    TAR(".tar"),
    TAR_GZ(".tar.gz"),
    RAR(".rar"),
    WAR(".war"),
    EAR(".ear"),
    ZIP(".zip"),
    Z(".z"),
    BZ2(".bz2"),
    GZ(".gz"),
    SEVEN_ZIP(".7z"),
    ARJ(".arj"),
    EML(".eml"),
    EMLX(".emlx"),
    BIN(".bin"),
    BAT(".bat"),
    CGI(".cgi"),
    COM(".com"),
    EXE(".exe"),
    MSI(".msi"),
    PL(".pl"),
    PY(".py"),
    VCF(".vcf"),
    APK(".apk"),
    ISO(".iso"),
    TOAST(".toast"),
    VCD(".vcd"),
    DMG(".dmg"),
    PKG(".pkg"),
    DEB(".deb"),
    RPM(".rpm"),
    PROPERTIES(".properties"),
    TXT(".txt"),
    XML(".xml"),
    JSON(".json"),
    JS(".js"),
    SQL(".sql"),
    LOG(".log"),
    CSV(".csv"),
    DAT(".dat"),
    DB(".db"),
    SAV(".sav"),
    DBF(".dbf"),
    MDB(".mdb"),
    AIF(".aif"),
    CDA(".cda"),
    MID(".mid"),
    MIDI(".midi"),
    WAV(".wav"),
    WMA(".wma"),
    FNT(".fnt"),
    FON(".fon"),
    OTF(".otf"),
    AI(".ai"),
    BMP(".bmp"),
    GIF(".gif"),
    ICO(".ico"),
    JPEG(".jpeg"),
    JPG(".jpg"),
    PNG(".png"),
    PS(".ps"),
    PSD(".psd"),
    SVG(".svg"),
    TIF(".tif"),
    TIFF(".tiff"),
    TTF(".ttf"),
    WSF(".wsf"),
    WPL(".wpl"),
    MP3(".mp3"),
    MPA(".mpa"),
    OGG(".ogg"),
    VELOCITY_TEMPLATE(".vm");

    private final String extension;

    private FileExtension(String extension) {
        this.extension = extension;
    }

    public static boolean is(File file, FileExtension fileExtension) {
        Objects.requireNonNull(file, "File must not be null");
        Objects.requireNonNull(fileExtension, "FileExtension must not be null");
        return FileExtension.is(file, fileExtension.getExtension());
    }

    public static boolean isKnown(File file) {
        FileExtension[] fileExtensions;
        Objects.requireNonNull(file, "File must not be null");
        Objects.requireNonNull(file, "FileExtension must not be null");
        for (FileExtension fileExtension : fileExtensions = FileExtension.values()) {
            if (!file.getName().endsWith(fileExtension.getExtension())) continue;
            return true;
        }
        return false;
    }

    public static boolean is(File file, String fileExtension) {
        Objects.requireNonNull(file, "File must not be null");
        Objects.requireNonNull(fileExtension, "String for the file extension must not be null");
        return fileExtension.startsWith(".") ? FilenameExtensions.getFileExtension(file, true).equals(fileExtension) : FilenameExtensions.getFileExtension(file, false).equals(fileExtension);
    }

    public String getExtension() {
        return this.extension;
    }
}

