/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.io.file;

import java.io.File;

public final class FilenameExtensions {
    private FilenameExtensions() {
    }

    public static String getFilenamePrefix(File file) {
        String fileName = file.getAbsolutePath();
        int filenameEndIndex = fileName.lastIndexOf(".");
        String fileNamePrefix = filenameEndIndex != -1 ? fileName.substring(0, filenameEndIndex) : fileName;
        return fileNamePrefix;
    }

    public static String getFileExtension(File file) {
        return FilenameExtensions.getFileExtension(file, false);
    }

    public static String getFileExtension(File file, boolean withDot) {
        String fileName;
        int filenameEndIndex;
        String fileNameSuffix = "";
        if (!file.isDirectory() && (filenameEndIndex = (fileName = file.getName()).lastIndexOf(".")) != -1) {
            int beginIndex = withDot ? filenameEndIndex : filenameEndIndex + 1;
            fileNameSuffix = fileName.substring(beginIndex);
        }
        return fileNameSuffix;
    }

    public static String getFilenameSuffix(File file) {
        String fileName;
        int filenameEndIndex;
        String fileNameSuffix = null;
        if (!file.isDirectory() && (filenameEndIndex = (fileName = file.getAbsolutePath()).lastIndexOf(".")) != -1) {
            fileNameSuffix = fileName.substring(filenameEndIndex, fileName.length());
        }
        return fileNameSuffix;
    }

    public static String getFilenameWithoutExtension(File file) {
        if (!file.isDirectory()) {
            String fileName = file.getName();
            return FilenameExtensions.getFilenameWithoutExtension(fileName);
        }
        return null;
    }

    public static String getFilenameWithoutExtension(String fileName) {
        int ext_index = fileName.lastIndexOf(".");
        String fileNamePrefix = ext_index != -1 ? fileName.substring(0, ext_index) : fileName;
        return fileNamePrefix;
    }
}

