/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.io.file.filter;

import java.io.File;
import java.io.FileFilter;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;

public class MultiplyExtensionsFileFilter
implements FileFilter {
    private final boolean recursive;
    private final Collection<String> fileExtensions;

    public MultiplyExtensionsFileFilter(boolean recursive, String ... fileExtensions) {
        this(Arrays.asList(fileExtensions), recursive);
    }

    public MultiplyExtensionsFileFilter(Collection<String> fileExtensions) {
        this(fileExtensions, false);
    }

    public MultiplyExtensionsFileFilter(Collection<String> fileExtensions, boolean recursive) {
        if (null == fileExtensions || fileExtensions.isEmpty()) {
            throw new IllegalArgumentException("Argument fileExtensions cant be null or empty. Please set the argument fileExtensions appropriate.");
        }
        this.recursive = recursive;
        this.fileExtensions = new LinkedHashSet<String>();
        for (String extension : fileExtensions) {
            this.fileExtensions.add(extension.toLowerCase());
        }
    }

    public MultiplyExtensionsFileFilter(String ... fileExtensions) {
        this(false, fileExtensions);
    }

    public static FileFilter of(Collection<String> fileExtensions) {
        return new MultiplyExtensionsFileFilter(fileExtensions);
    }

    public static FileFilter of(Collection<String> fileExtensions, boolean recursive) {
        return new MultiplyExtensionsFileFilter(fileExtensions, recursive);
    }

    public static FileFilter of(boolean recursive, String ... fileExtensions) {
        return new MultiplyExtensionsFileFilter(recursive, fileExtensions);
    }

    public static FileFilter of(String ... fileExtensions) {
        return new MultiplyExtensionsFileFilter(fileExtensions);
    }

    @Override
    public boolean accept(File pathname) {
        if (this.recursive && pathname.isDirectory()) {
            return true;
        }
        String filename = pathname.getName();
        for (String extension : this.fileExtensions) {
            if (!filename.endsWith(extension)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "[MultiplyExtensionsFileFilter: fileExtensions: " + this.fileExtensions + " recursive: " + this.recursive + "]";
    }
}

