/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.io.file.namefilter;

import java.io.File;
import java.io.FilenameFilter;
import java.util.Objects;

public class SimpleFilenameFilter
implements FilenameFilter {
    private final boolean recursive;
    private final String fileSuffix;

    public SimpleFilenameFilter(String fileSuffix, boolean recursive) {
        Objects.requireNonNull(fileSuffix);
        if (fileSuffix.equals("")) {
            throw new IllegalArgumentException("Argument fileSuffix cant be empty. Please set the argument fileSuffix.");
        }
        this.fileSuffix = fileSuffix.toLowerCase();
        this.recursive = recursive;
    }

    public SimpleFilenameFilter(String fileSuffix) {
        this(fileSuffix, false);
    }

    public static FilenameFilter of(String suffix) {
        return new SimpleFilenameFilter(suffix);
    }

    public static FilenameFilter of(String suffix, boolean recursive) {
        return new SimpleFilenameFilter(suffix, recursive);
    }

    @Override
    public boolean accept(File dir, String name) {
        File currentFile = new File(dir, name);
        if (this.recursive && currentFile.isDirectory()) {
            return true;
        }
        return name.toLowerCase().endsWith(this.fileSuffix);
    }

    public String toString() {
        return "[SimpleFilenameFilter: fileSuffix: " + this.fileSuffix + " recursive: " + this.recursive + "]";
    }
}

