/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.io.annotation;

public class ClassloaderExtensions {
    public static ClassLoader getClassLoader() {
        return ClassloaderExtensions.getClassLoader(null);
    }

    public static ClassLoader getClassLoader(Object obj) {
        ClassLoader classLoader = null;
        if (null != obj) {
            classLoader = ClassloaderExtensions.isDerivate(Thread.currentThread().getContextClassLoader(), obj.getClass().getClassLoader()) ? obj.getClass().getClassLoader() : Thread.currentThread().getContextClassLoader();
            if (ClassloaderExtensions.isDerivate(classLoader, ClassLoader.getSystemClassLoader())) {
                classLoader = ClassLoader.getSystemClassLoader();
            }
        } else {
            classLoader = ClassloaderExtensions.isDerivate(Thread.currentThread().getContextClassLoader(), ClassLoader.getSystemClassLoader()) ? ClassLoader.getSystemClassLoader() : Thread.currentThread().getContextClassLoader();
        }
        return classLoader;
    }

    public static boolean isDerivate(ClassLoader source, ClassLoader compare) {
        if (source == compare) {
            return true;
        }
        if (compare == null) {
            return false;
        }
        if (source == null) {
            return true;
        }
        while (null != compare) {
            if (source != (compare = compare.getParent())) continue;
            return true;
        }
        return false;
    }
}

