/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.io.file.filter;

import java.io.File;
import java.io.FileFilter;

public class PrefixFileFilter
implements FileFilter {
    private final String prefix;
    private final boolean recursive;

    public PrefixFileFilter(String prefix, boolean recursive) {
        this.prefix = prefix;
        this.recursive = recursive;
    }

    public PrefixFileFilter(String prefix) {
        this.prefix = prefix;
        this.recursive = true;
    }

    public static FileFilter of(String prefix) {
        return new PrefixFileFilter(prefix);
    }

    public static FileFilter of(String prefix, boolean recursive) {
        return new PrefixFileFilter(prefix, recursive);
    }

    @Override
    public boolean accept(File file) {
        if (this.recursive && file.isDirectory()) {
            return true;
        }
        return file.getName().startsWith(this.prefix);
    }
}

