/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.io.file.filter;

import java.io.File;
import java.io.FileFilter;

public class SuffixFileFilter
implements FileFilter {
    private final String suffix;
    private final String description;
    private final boolean recursive;

    public SuffixFileFilter(String suffix, boolean recursive) {
        this(suffix, "", recursive);
    }

    public SuffixFileFilter(String suffix) {
        this(suffix, true);
    }

    public SuffixFileFilter(String suffix, String description, boolean recursive) {
        this.suffix = suffix;
        this.recursive = recursive;
        this.description = description;
    }

    public static FileFilter of(String suffix, boolean recursive) {
        return new SuffixFileFilter(suffix, recursive);
    }

    public static FileFilter of(String suffix) {
        return new SuffixFileFilter(suffix);
    }

    @Override
    public boolean accept(File file) {
        if (this.recursive && file.isDirectory()) {
            return true;
        }
        String fileName = file.getName().toLowerCase();
        return fileName.endsWith(this.suffix);
    }

    public String getDescription() {
        return this.description;
    }
}

