/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.io.file.namefilter;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;

public class MultiplyExtensionsFilenameFilter
implements FilenameFilter {
    private final boolean recursive;
    private final Collection<String> fileExtensions;

    public MultiplyExtensionsFilenameFilter(Collection<String> fileExtensions) {
        this(fileExtensions, false);
    }

    public MultiplyExtensionsFilenameFilter(Collection<String> fileExtensions, boolean recursive) {
        Objects.requireNonNull(fileExtensions);
        if (fileExtensions.isEmpty()) {
            throw new IllegalArgumentException("Argument fileExtensions cant be empty. Please set the argument fileExtensions appropriate.");
        }
        this.fileExtensions = new ArrayList<String>(fileExtensions.size());
        this.recursive = recursive;
        for (String extension : fileExtensions) {
            this.fileExtensions.add(extension.toLowerCase());
        }
    }

    public static FilenameFilter of(Collection<String> fileExtensions) {
        return new MultiplyExtensionsFilenameFilter(fileExtensions);
    }

    public static FilenameFilter of(Collection<String> fileExtensions, boolean recursive) {
        return new MultiplyExtensionsFilenameFilter(fileExtensions, recursive);
    }

    @Override
    public boolean accept(File dir, String name) {
        File currentFile = new File(dir, name);
        if (this.recursive && currentFile.isDirectory()) {
            return true;
        }
        for (String extension : this.fileExtensions) {
            if (!name.endsWith(extension)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "[MultiplyExtensionsFilenameFilter: fileExtensions: " + this.fileExtensions + " recursive: " + this.recursive + "]";
    }
}

