/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.io.shell;

import io.github.astrapi69.io.StreamExtensions;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;

public final class LinuxShellExecutor {
    private LinuxShellExecutor() {
    }

    public static String execute(String shellPath, String executionPath, String command) throws IOException, InterruptedException {
        String line;
        File executionDirectory;
        if (executionPath.contains("~")) {
            executionPath = executionPath.replace("~", System.getProperty("user.home"));
        }
        if (!(executionDirectory = new File(executionPath)).exists()) {
            throw new IllegalArgumentException("Execution directory does not exist");
        }
        String cdToExecutionPath = "cd " + executionPath;
        String commands = cdToExecutionPath + " && " + command;
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
        processBuilder.command(shellPath, "-c", commands);
        Process process = processBuilder.start();
        StringBuilder stringBuilder = new StringBuilder();
        BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        while ((line = reader.readLine()) != null) {
            stringBuilder.append(line).append(System.lineSeparator());
        }
        int waitFor = process.waitFor();
        if (waitFor != 0) {
            stringBuilder.append("Exit code: ").append(waitFor).append("\n");
        }
        return stringBuilder.toString();
    }

    public static String execute(boolean withResponse, String ... command) throws IOException {
        ArrayList<String> commands = new ArrayList<String>();
        commands.add("bash");
        commands.add("-c");
        commands.addAll(Arrays.asList(command));
        String response = "";
        ProcessBuilder pb = new ProcessBuilder(commands);
        pb.redirectErrorStream(true);
        Process shell = pb.start();
        if (withResponse) {
            try (InputStream shellIn = shell.getInputStream();){
                response = StreamExtensions.toString(shellIn);
            }
        }
        return response;
    }
}

