/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.io;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;

public final class StreamExtensions {
    private StreamExtensions() {
    }

    public static byte[] getByteArray(File file) throws IOException {
        return StreamExtensions.getByteArray(StreamExtensions.getInputStream(file));
    }

    public static byte[] getByteArray(InputStream in) throws IOException {
        return StreamExtensions.getByteArray(in, new ByteArrayOutputStream(in.available()));
    }

    public static byte[] getByteArray(InputStream in, ByteArrayOutputStream os) throws IOException {
        int byt;
        while ((byt = in.read()) != -1) {
            os.write(byt);
        }
        return os.toByteArray();
    }

    public static InputStream getInputStream(File file) throws IOException {
        return StreamExtensions.getInputStream(file, false);
    }

    public static InputStream getInputStream(File file, boolean createFile) throws IOException {
        InputStream is;
        if (file.exists()) {
            is = file.toURI().toURL().openStream();
        } else if (createFile) {
            file.createNewFile();
            is = file.toURI().toURL().openStream();
        } else {
            throw new FileNotFoundException("File " + file.getName() + " does not exist.");
        }
        return is;
    }

    public static InputStream getInputStream(String fullpathWithFilename) throws IOException {
        return StreamExtensions.getInputStream(Paths.get(fullpathWithFilename, new String[0]));
    }

    public static InputStream getInputStream(Path path) throws IOException {
        return Files.newInputStream(path, new OpenOption[0]);
    }

    public static OutputStream getOutputStream(String fullPathWithFilename) throws IOException {
        return StreamExtensions.getOutputStream(Paths.get(fullPathWithFilename, new String[0]));
    }

    public static OutputStream getOutputStream(Path path) throws IOException {
        return Files.newOutputStream(path, new OpenOption[0]);
    }

    public static OutputStream getOutputStream(File file) throws IOException {
        return StreamExtensions.getOutputStream(file, false);
    }

    public static OutputStream getOutputStream(File file, boolean createFile) throws IOException {
        FileOutputStream os = null;
        BufferedOutputStream bos = null;
        if (file.exists()) {
            os = new FileOutputStream(file);
        } else if (createFile) {
            file.createNewFile();
            os = new FileOutputStream(file);
        } else {
            throw new FileNotFoundException("File " + file.getName() + " does not exist.");
        }
        bos = new BufferedOutputStream(os);
        return bos;
    }

    public static Reader getReader(File inputFile) throws IOException {
        return StreamExtensions.getReader(inputFile, null, false);
    }

    public static Reader getReader(File inputFile, String encoding, boolean createFile) throws IOException {
        FileInputStream fis;
        if (inputFile.exists()) {
            fis = new FileInputStream(inputFile);
        } else if (createFile) {
            inputFile.createNewFile();
            fis = new FileInputStream(inputFile);
        } else {
            throw new FileNotFoundException("File " + inputFile.getName() + " does not exist.");
        }
        InputStreamReader isr = null == encoding ? new InputStreamReader(fis) : new InputStreamReader((InputStream)fis, encoding);
        BufferedReader reader = new BufferedReader(isr);
        return reader;
    }

    public static long getSerialVersionUID(Class<? extends Serializable> clazz) {
        return ObjectStreamClass.lookup(clazz).getSerialVersionUID();
    }

    public static Writer getWriter(File file) throws IOException {
        return StreamExtensions.getWriter(file, null, false);
    }

    public static Writer getWriter(File file, String encoding, boolean createFile) throws IOException {
        FileOutputStream fos;
        if (file.exists()) {
            fos = new FileOutputStream(file);
        } else if (createFile) {
            file.createNewFile();
            fos = new FileOutputStream(file);
        } else {
            throw new FileNotFoundException("File " + file.getName() + "does not exist.");
        }
        BufferedOutputStream bos = new BufferedOutputStream(fos);
        OutputStreamWriter osw = null == encoding ? new OutputStreamWriter(bos) : new OutputStreamWriter((OutputStream)bos, encoding);
        PrintWriter printWriter = new PrintWriter(osw);
        return printWriter;
    }

    public static void writeInputStreamToOutputStream(InputStream inputStream, OutputStream outputStream) throws IOException {
        int nextByte;
        while ((nextByte = inputStream.read()) != -1) {
            outputStream.write(nextByte);
        }
    }

    public static void writeReaderToWriter(Reader reader, Writer writer) throws IOException {
        int character;
        while ((character = reader.read()) != -1) {
            writer.write(character);
        }
    }

    public static String toString(InputStream is) throws IOException {
        if (is != null) {
            String line;
            StringBuilder sb = new StringBuilder();
            BufferedReader br = new BufferedReader(new InputStreamReader(is, "UTF-8"));
            while ((line = br.readLine()) != null) {
                sb.append(line).append("\n");
            }
            return sb.toString();
        }
        return "";
    }
}

