/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.io.file;

import io.github.astrapi69.io.file.FilenameExtensions;
import java.io.File;
import java.util.Objects;
import java.util.Set;

public enum FileExtension {
    AI(".ai"),
    AIF(".aif"),
    APK(".apk"),
    ARJ(".arj"),
    AVI(".avi"),
    BACKUP(".bak"),
    BAT(".bat"),
    BIN(".bin"),
    BMP(".bmp"),
    BZ2(".bz2"),
    CDA(".cda"),
    CGI(".cgi"),
    CLASS(".class"),
    COM(".com"),
    CONF(".conf"),
    CONFIG(".config"),
    CPP(".cpp"),
    CSS(".css"),
    CSV(".csv"),
    DAT(".dat"),
    DB(".db"),
    DBF(".dbf"),
    DEB(".deb"),
    DECRYPTED(".decrypted"),
    DMG(".dmg"),
    DOC(".doc"),
    DOCX(".docx"),
    DOTX(".dotx"),
    EAR(".ear"),
    EML(".eml"),
    EMLX(".emlx"),
    ENCRYPTED(".enc"),
    ENV(".env"),
    EXE(".exe"),
    FLAC(".flac"),
    FLV(".flv"),
    FNT(".fnt"),
    FODT(".fodt"),
    FON(".fon"),
    GIF(".gif"),
    GZ(".gz"),
    H(".h"),
    HEIC(".heic"),
    HTML(".html"),
    ICO(".ico"),
    INI(".ini"),
    ISO(".iso"),
    JAR(".jar"),
    JAVA(".java"),
    JPEG(".jpeg"),
    JPG(".jpg"),
    JS(".js"),
    JSON(".json"),
    KT(".kt"),
    LOG(".log"),
    M4A(".m4a"),
    MDB(".mdb"),
    MID(".mid"),
    MIDI(".midi"),
    MKV(".mkv"),
    MOV(".mov"),
    MP3(".mp3"),
    MP4(".mp4"),
    MPA(".mpa"),
    MSI(".msi"),
    MYSTIC_CRYPT_ENCRYPTED(".mcrdb"),
    ODT(".odt"),
    OGG(".ogg"),
    OTF(".otf"),
    OTT(".ott"),
    PDF(".pdf"),
    PKG(".pkg"),
    PL(".pl"),
    PNG(".png"),
    PPT(".ppt"),
    PPTX(".pptx"),
    PROPERTIES(".properties"),
    PS(".ps"),
    PSD(".psd"),
    PY(".py"),
    RAR(".rar"),
    RAW(".raw"),
    RPM(".rpm"),
    RTF(".rtf"),
    SAV(".sav"),
    SEVEN_ZIP(".7z"),
    SQL(".sql"),
    SVG(".svg"),
    TAR(".tar"),
    TAR_GZ(".tar.gz"),
    TIF(".tif"),
    TIFF(".tiff"),
    TOAST(".toast"),
    TS(".ts"),
    TTF(".ttf"),
    TXT(".txt"),
    UOT(".uot"),
    VCD(".vcd"),
    VCF(".vcf"),
    VELOCITY_TEMPLATE(".vm"),
    WAR(".war"),
    WAV(".wav"),
    WEBP(".webp"),
    WMA(".wma"),
    WMV(".wmv"),
    WPL(".wpl"),
    WSF(".wsf"),
    XLS(".xls"),
    XLSX(".xlsx"),
    XML(".xml"),
    YAML(".yaml"),
    YML(".yml"),
    Z(".z"),
    ZIP(".zip");

    public static final String[] ZIP_EXTENSIONS;
    private final String extension;

    public static Set<String> getZipExtensions() {
        return Set.of(ZIP_EXTENSIONS);
    }

    public static boolean is(File file, FileExtension fileExtension) {
        Objects.requireNonNull(file, "File must not be null");
        Objects.requireNonNull(fileExtension, "FileExtension must not be null");
        return FileExtension.is(file, fileExtension.getExtension());
    }

    public static boolean is(File file, String fileExtension) {
        Objects.requireNonNull(file, "File must not be null");
        Objects.requireNonNull(fileExtension, "String for the file extension must not be null");
        return fileExtension.startsWith(".") ? FilenameExtensions.getFileExtension(file, true).equals(fileExtension) : FilenameExtensions.getFileExtension(file, false).equals(fileExtension);
    }

    public static boolean isKnown(File file) {
        FileExtension[] fileExtensions;
        Objects.requireNonNull(file, "File must not be null");
        Objects.requireNonNull(file, "FileExtension must not be null");
        for (FileExtension fileExtension : fileExtensions = FileExtension.values()) {
            if (!file.getName().endsWith(fileExtension.getExtension())) continue;
            return true;
        }
        return false;
    }

    public static FileExtension resolve(String fileExtension) {
        if (fileExtension == null) {
            return null;
        }
        for (FileExtension extension : FileExtension.values()) {
            if (!extension.getExtension().equalsIgnoreCase(fileExtension)) continue;
            return extension;
        }
        return null;
    }

    private FileExtension(String extension) {
        this.extension = extension;
    }

    public String getExtension() {
        return this.extension;
    }

    public String getExtensionOnly() {
        return this.extension.substring(1, this.extension.length());
    }

    static {
        ZIP_EXTENSIONS = new String[]{ZIP.getExtension(), JAR.getExtension(), WAR.getExtension(), EAR.getExtension(), TAR.getExtension(), RAR.getExtension(), SEVEN_ZIP.getExtension(), BZ2.getExtension(), GZ.getExtension(), TAR_GZ.getExtension(), Z.getExtension(), ARJ.getExtension()};
    }
}

