/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.io.file;

import io.github.astrapi69.io.file.FileExtension;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public final class FilenameExtensions {
    private FilenameExtensions() {
    }

    public static Map<Character, String> getCharacterFileReplacementMap() {
        HashMap<Character, String> replacementMap = new HashMap<Character, String>();
        replacementMap.put(Character.valueOf(' '), "_");
        replacementMap.put(Character.valueOf('.'), "-");
        replacementMap.put(Character.valueOf('/'), "-");
        replacementMap.put(Character.valueOf('\\'), "-");
        replacementMap.put(Character.valueOf(':'), "-");
        replacementMap.put(Character.valueOf('*'), "_");
        replacementMap.put(Character.valueOf('?'), "_");
        replacementMap.put(Character.valueOf('\"'), "_");
        replacementMap.put(Character.valueOf('<'), "_");
        replacementMap.put(Character.valueOf('>'), "_");
        replacementMap.put(Character.valueOf('|'), "_");
        return replacementMap;
    }

    public static String sanitizeFilename(String filename, Map<Character, String> replacementMap) {
        StringBuilder sanitized = new StringBuilder();
        int lastDotIndex = filename.lastIndexOf(46);
        String namePart = lastDotIndex != -1 ? filename.substring(0, lastDotIndex) : filename;
        String extensionPart = lastDotIndex != -1 ? filename.substring(lastDotIndex) : "";
        for (char c : namePart.toCharArray()) {
            char lowerCaseChar = Character.toLowerCase(c);
            if (replacementMap.containsKey(Character.valueOf(lowerCaseChar))) {
                sanitized.append(replacementMap.get(Character.valueOf(lowerCaseChar)));
                continue;
            }
            sanitized.append(c);
        }
        sanitized.append(extensionPart);
        return sanitized.toString();
    }

    public static String getFilenamePrefix(File file) {
        String fileName = file.getAbsolutePath();
        int filenameEndIndex = fileName.lastIndexOf(".");
        String fileNamePrefix = filenameEndIndex != -1 ? fileName.substring(0, filenameEndIndex) : fileName;
        return fileNamePrefix;
    }

    public static String getName(File file) {
        String fileName = file.getName();
        return fileName;
    }

    public static String getFileExtension(File file) {
        return FilenameExtensions.getFileExtension(file, false);
    }

    public static String getFileExtension(File file, boolean withDot) {
        String fileName;
        int filenameEndIndex;
        String fileNameSuffix = "";
        if (!file.isDirectory() && (filenameEndIndex = (fileName = file.getName()).lastIndexOf(".")) != -1) {
            int beginIndex = withDot ? filenameEndIndex : filenameEndIndex + 1;
            fileNameSuffix = fileName.substring(beginIndex);
        }
        return fileNameSuffix;
    }

    public static String getFilenameSuffix(File file) {
        String fileName;
        int filenameEndIndex;
        String fileNameSuffix = null;
        if (!file.isDirectory() && (filenameEndIndex = (fileName = file.getAbsolutePath()).lastIndexOf(".")) != -1) {
            fileNameSuffix = fileName.substring(filenameEndIndex, fileName.length());
        }
        return fileNameSuffix;
    }

    public static String getFilenameWithoutExtension(File file) {
        if (!file.isDirectory()) {
            String fileName = file.getName();
            return FilenameExtensions.getFilenameWithoutExtension(fileName);
        }
        return null;
    }

    public static String getFilenameWithNewExtension(File file, String newExtension) {
        Objects.requireNonNull(file, "File must not be null");
        Objects.requireNonNull(newExtension, "The new extension must not be null");
        String fileName = FilenameExtensions.getFilenameWithoutExtension(file);
        if (fileName != null) {
            String newFileName = fileName + newExtension;
            return newFileName;
        }
        return null;
    }

    public static String getFilenameWithNewExtension(File file, FileExtension newExtension) {
        String fileName = FilenameExtensions.getFilenameWithoutExtension(file);
        if (fileName != null) {
            String newFileName = fileName + newExtension.getExtension();
            return newFileName;
        }
        return null;
    }

    public static String getFilenameWithoutExtension(String fileName) {
        int ext_index = fileName.lastIndexOf(".");
        String fileNamePrefix = ext_index != -1 ? fileName.substring(0, ext_index) : fileName;
        return fileNamePrefix;
    }
}

