/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.io.shell;

import io.github.astrapi69.io.shell.OS;
import io.github.astrapi69.io.shell.ProcessBuilderFactory;
import io.github.astrapi69.io.shell.TeeOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class CommandLineExecutor {
    private CommandLineExecutor() {
    }

    public static String execute(String executionPath, String command, OutputStream additionalOutput) throws IOException, InterruptedException {
        String shellPath;
        OS currentOS = OS.get();
        return CommandLineExecutor.execute(shellPath, switch (currentOS) {
            case OS.WINDOWS -> {
                shellPath = "cmd.exe";
                yield "/c";
            }
            case OS.MAC, OS.LINUX, OS.UNIX -> {
                shellPath = "/bin/bash";
                yield "-c";
            }
            default -> throw new UnsupportedOperationException("Unsupported operating system: " + currentOS);
        }, executionPath, command, additionalOutput);
    }

    private static String execute(String shellPath, String shellFlag, String executionPath, String command, OutputStream additionalOutput) throws IOException, InterruptedException {
        ProcessBuilder processBuilder = ProcessBuilderFactory.newProcessBuilder(shellPath, shellFlag, executionPath, command);
        processBuilder.redirectErrorStream(true);
        Process process = processBuilder.start();
        StringBuilder output = new StringBuilder();
        try (InputStream processOutput = process.getInputStream();
             TeeOutputStream teeOutputStream = new TeeOutputStream(new ByteArrayOutputStream(), additionalOutput);
             BufferedReader reader = new BufferedReader(new InputStreamReader(processOutput));){
            String line;
            while ((line = reader.readLine()) != null) {
                output.append(line).append(System.lineSeparator());
                teeOutputStream.write(line.getBytes());
                teeOutputStream.write(System.lineSeparator().getBytes());
            }
        }
        int exitCode = process.waitFor();
        if (exitCode != 0) {
            output.append("Exit code: ").append(exitCode).append(System.lineSeparator());
        }
        return output.toString();
    }

    public static List<String> getCommandList(String[] commands, OS currentOS) {
        ArrayList<String> commandList = new ArrayList<String>();
        switch (currentOS) {
            case WINDOWS: {
                commandList.add("cmd.exe");
                commandList.add("/c");
                break;
            }
            case MAC: 
            case LINUX: 
            case UNIX: {
                commandList.add("/bin/bash");
                commandList.add("-c");
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported operating system: " + currentOS);
            }
        }
        commandList.addAll(Arrays.asList(commands));
        return commandList;
    }
}

