/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.string;

import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Optional;

public final class CharsetExtensions {
    private CharsetExtensions() {
    }

    public static Optional<Charset> getCharset(String encoding) {
        if (encoding == null) {
            return Optional.empty();
        }
        Charset charset = null;
        try {
            charset = Charset.forName(encoding);
        }
        catch (UnsupportedCharsetException exception) {
            Optional.empty();
        }
        return charset != null ? Optional.of(charset) : Optional.empty();
    }
}

