/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.string;

import io.github.astrapi69.string.MalformedUnicodeException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public final class StringExtensions {
    private static final char[] HEXADECIMAL_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    private StringExtensions() {
    }

    public static String addDoubleQuotationMarks(String s) {
        Objects.requireNonNull(s);
        return "\"" + s + "\"";
    }

    public static String addSingleQuotationMarks(String s) {
        Objects.requireNonNull(s);
        return "'" + s + "'";
    }

    public static byte[] convertToBytearray(char[] source) {
        if (source == null) {
            return null;
        }
        byte[] result = new byte[source.length];
        for (int i = 0; i < source.length; ++i) {
            result[i] = (byte)source[i];
        }
        return result;
    }

    public static char[] convertToCharArray(byte[] source) {
        if (source == null) {
            return null;
        }
        char[] result = new char[source.length];
        for (int i = 0; i < source.length; ++i) {
            result[i] = (char)source[i];
        }
        return result;
    }

    public static Character convertUnicodeStringToCharacter(String theUnicodeString) {
        Objects.requireNonNull(theUnicodeString);
        int length = theUnicodeString.length();
        StringBuilder sb = new StringBuilder(length);
        int outerCount = 0;
        while (outerCount < length) {
            int current;
            if ((current = theUnicodeString.charAt(outerCount++)) == 92) {
                if ((current = theUnicodeString.charAt(outerCount++)) == 117) {
                    int value = 0;
                    block6: for (int i = 0; i < 4; ++i) {
                        current = theUnicodeString.charAt(outerCount++);
                        switch (current) {
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: {
                                value = (value << 4) + current - 48;
                                continue block6;
                            }
                            case 97: 
                            case 98: 
                            case 99: 
                            case 100: 
                            case 101: 
                            case 102: {
                                value = (value << 4) + 10 + current - 97;
                                continue block6;
                            }
                            case 65: 
                            case 66: 
                            case 67: 
                            case 68: 
                            case 69: 
                            case 70: {
                                value = (value << 4) + 10 + current - 65;
                                continue block6;
                            }
                            default: {
                                throw new MalformedUnicodeException("Given String object :::" + theUnicodeString + "::: is not a well formed unicode String object.\nFormat for a well formed unicode String object:'\\uxxxx'.");
                            }
                        }
                    }
                    sb.append((char)value);
                    continue;
                }
                if (current == 116) {
                    current = 9;
                } else if (current == 114) {
                    current = 13;
                } else if (current == 110) {
                    current = 10;
                } else if (current == 102) {
                    current = 12;
                }
                sb.append((char)current);
                continue;
            }
            sb.append((char)current);
        }
        String result = sb.toString();
        return Character.valueOf(result.charAt(0));
    }

    public static List<String> filterStringsWithSeperator(List<String> ignoreFieldNames, String separator) {
        Objects.requireNonNull(ignoreFieldNames);
        Objects.requireNonNull(separator);
        return ignoreFieldNames.stream().map(str -> {
            int pos = str.indexOf(separator);
            if (pos == -1) {
                return "";
            }
            return str.substring(pos + separator.length());
        }).filter(value -> value != null && !value.isEmpty()).collect(Collectors.toList());
    }

    public static String firstCharacterToLowerCase(String fieldName) {
        if (StringUtils.isNotEmpty((CharSequence)fieldName)) {
            String firstCharacter = fieldName.substring(0, 1);
            firstCharacter = firstCharacter.toLowerCase();
            char[] fc = firstCharacter.toCharArray();
            char[] fn = fieldName.toCharArray();
            fn[0] = fc[0];
            return new String(fn);
        }
        return fieldName;
    }

    public static String firstCharacterToUpperCase(String fieldName) {
        if (StringUtils.isNotEmpty((CharSequence)fieldName)) {
            String firstCharacter = fieldName.substring(0, 1);
            firstCharacter = firstCharacter.toUpperCase();
            char[] fc = firstCharacter.toCharArray();
            char[] fn = fieldName.toCharArray();
            fn[0] = fc[0];
            return new String(fn);
        }
        return fieldName;
    }

    public static String getAttributName(String name) {
        Objects.requireNonNull(name);
        int indexStart = name.indexOf("[");
        return name.substring(0, indexStart);
    }

    public static String getIndex(String name) {
        Objects.requireNonNull(name);
        int firstIndexStart = name.indexOf("[");
        int firstIndexEnd = name.indexOf("]");
        return name.substring(firstIndexStart + 1, firstIndexEnd);
    }

    public static String getItemNumber(String name) {
        Objects.requireNonNull(name);
        int lastIndexStart = name.lastIndexOf("[");
        int lastIndexEnd = name.lastIndexOf("]");
        return name.substring(lastIndexStart + 1, lastIndexEnd);
    }

    public static String getStringAfterUnderscore(String element) {
        Objects.requireNonNull(element);
        int i = element.indexOf("_");
        String returnString = element.substring(i + 1);
        return returnString;
    }

    public static String getStringBeforeUnderscore(String element) {
        Objects.requireNonNull(element);
        return element.substring(0, element.indexOf("_"));
    }

    public static String getValue(Map<String, String> data, String key, String defaultValue) {
        Objects.requireNonNull(data);
        String value = data.get(key);
        if (value == null || value.isEmpty()) {
            value = defaultValue;
        }
        return value;
    }

    public static boolean isNullOrEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public static boolean isNumber(String testString) {
        if (StringUtils.isEmpty((CharSequence)testString)) {
            return false;
        }
        for (int i = 0; i < testString.length(); ++i) {
            if (Character.isDigit(testString.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String lastCharacter(String str) {
        if (str == null || str.length() == 0) {
            return "";
        }
        return str.substring(str.length() - 1);
    }

    public static String lastCharacterToUpperCase(String fieldName) {
        if (StringUtils.isNotEmpty((CharSequence)fieldName)) {
            int length = fieldName.length();
            String lastCharacter = fieldName.substring(length - 1, length);
            lastCharacter = lastCharacter.toUpperCase();
            char[] fc = lastCharacter.toCharArray();
            char[] fn = fieldName.toCharArray();
            fn[length - 1] = fc[0];
            return new String(fn);
        }
        return fieldName;
    }

    public static String readLine(String stringWithCarriageReturns) {
        String returnString = "";
        int index = 0;
        index = stringWithCarriageReturns.indexOf(System.getProperty("line.separator"));
        if (index < 0) {
            index = stringWithCarriageReturns.indexOf("\n");
        }
        if (index < 0) {
            index = stringWithCarriageReturns.indexOf("\r");
        }
        returnString = stringWithCarriageReturns.substring(0, index);
        return returnString;
    }

    public static String[] removeEmptyString(String[] words) {
        ArrayList<String> al = new ArrayList<String>();
        for (int i = 0; i < words.length; ++i) {
            if (words[i].isEmpty()) continue;
            al.add(words[i]);
        }
        return al.toArray(new String[al.size()]);
    }

    public static String removeFirstAndLastCharacter(String s) {
        Objects.requireNonNull(s);
        return s.substring(1, s.length() - 1);
    }

    public static String removeNewlineCharacters(String subject) {
        if (subject.contains("\n")) {
            subject = subject.replace("\n", "");
        }
        if (subject.contains("\r")) {
            subject = subject.replace("\r", "");
        }
        return subject;
    }

    public static String removeQuotationMarks(String s) {
        Objects.requireNonNull(s);
        return StringExtensions.removeFirstAndLastCharacter(s);
    }

    public static String replaceAll(String original, String findString, String replaceWith) {
        Objects.requireNonNull(original);
        Objects.requireNonNull(findString);
        Objects.requireNonNull(replaceWith);
        StringBuilder originalFiltered = new StringBuilder();
        int next = 0;
        int count = 0;
        int length = findString.length();
        while (count > -1) {
            count = original.indexOf(findString, next);
            if (count <= -1) continue;
            originalFiltered.append(original, next, count);
            originalFiltered.append(replaceWith);
            next = count + length;
        }
        originalFiltered.append(original.substring(next));
        return originalFiltered.toString();
    }

    public static String replaceAll(String original, String[] findString, String replaceWith) {
        Objects.requireNonNull(original);
        Objects.requireNonNull(findString);
        Objects.requireNonNull(replaceWith);
        String result = original;
        for (String element : findString) {
            result = StringExtensions.replaceAll(result, element, replaceWith);
        }
        return result;
    }

    public static String replaceAll(String original, Map<String, String> replaceWith) {
        Objects.requireNonNull(original);
        Objects.requireNonNull(replaceWith);
        String result = original;
        for (Map.Entry<String, String> entry : replaceWith.entrySet()) {
            result = StringExtensions.replaceAll(result, entry.getKey(), entry.getValue());
        }
        return result;
    }

    public static String replaceEach(String input, String searchRegexPattern, String replace) {
        Objects.requireNonNull(input);
        Objects.requireNonNull(searchRegexPattern);
        Objects.requireNonNull(replace);
        Pattern pattern = Pattern.compile(searchRegexPattern);
        Matcher matcher = pattern.matcher(input);
        return matcher.replaceAll(replace);
    }

    public static String replaceLast(String original, String findString, String replacement) {
        Objects.requireNonNull(original);
        Objects.requireNonNull(findString);
        Objects.requireNonNull(replacement);
        int index = original.lastIndexOf(findString);
        if (index == -1) {
            return original;
        }
        StringBuilder originalFiltered = new StringBuilder();
        originalFiltered.append(original, 0, index);
        originalFiltered.append(replacement);
        originalFiltered.append(original.substring(index + findString.length()));
        return originalFiltered.toString().trim();
    }

    public static List<String> splitByFixedLength(String input, int fixedLength) {
        Objects.requireNonNull(input);
        ArrayList<String> parts = new ArrayList<String>();
        for (int beginIndex = 0; beginIndex < input.length(); beginIndex += fixedLength) {
            int endIndex = Math.min(beginIndex + fixedLength, input.length());
            String part = input.substring(beginIndex, endIndex);
            parts.add(part);
        }
        return parts;
    }

    private static char toHex(int i) {
        return HEXADECIMAL_DIGITS[i & 0xF];
    }

    public static int[] toIntegerArray(String integerArrayAsString, String delimiter) throws NumberFormatException {
        Objects.requireNonNull(integerArrayAsString);
        Objects.requireNonNull(delimiter);
        String[] splittedNumbers = integerArrayAsString.replaceAll("\\s", "").split(delimiter);
        int[] integerArray = new int[splittedNumbers.length];
        for (int i = 0; i < splittedNumbers.length; ++i) {
            int currentNumber;
            integerArray[i] = currentNumber = Integer.parseInt(splittedNumbers[i]);
        }
        return integerArray;
    }

    public static <T> String toString(T object) {
        Objects.requireNonNull(object);
        return Objects.toString(object);
    }

    public static String toUnicode(String toUnicode, boolean toLowerCase) {
        Objects.requireNonNull(toUnicode);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < toUnicode.length(); ++i) {
            String hex = Integer.toHexString(toUnicode.codePointAt(i));
            hex = toLowerCase ? hex.toLowerCase() : hex.toUpperCase();
            String hexWithZeros = "0000" + hex;
            String hexCodeWithLeadingZeros = hexWithZeros.substring(hexWithZeros.length() - 4);
            sb.append("\\u" + hexCodeWithLeadingZeros);
        }
        return sb.toString();
    }

    public static String toUnicodeChars(String s, boolean toLowerCase) {
        Objects.requireNonNull(s);
        if (s.length() == 0) {
            return s;
        }
        int length = s.length();
        int sbLength = length * 2;
        StringBuilder sb = new StringBuilder(sbLength);
        block8: for (int i = 0; i < length; ++i) {
            char c = s.charAt(i);
            if (c > '=' && c < '\u007f') {
                if (c == '\\') {
                    sb.append('\\');
                    sb.append('\\');
                    continue;
                }
                sb.append(c);
                continue;
            }
            switch (c) {
                case '\f': {
                    sb.append('\\');
                    sb.append('f');
                    continue block8;
                }
                case '\n': {
                    sb.append('\\');
                    sb.append('n');
                    continue block8;
                }
                case '\r': {
                    sb.append('\\');
                    sb.append('r');
                    continue block8;
                }
                case '\t': {
                    sb.append('\\');
                    sb.append('t');
                    continue block8;
                }
                case ' ': {
                    if (i == 0) {
                        sb.append('\\');
                    }
                    sb.append(' ');
                    continue block8;
                }
                case '!': 
                case '#': 
                case ':': 
                case '=': {
                    sb.append('\\');
                    sb.append(c);
                    continue block8;
                }
                default: {
                    if (c < ' ' || c > '~') {
                        sb.append('\\');
                        sb.append('u');
                        sb.append(StringExtensions.toHex(c >> 12 & 0xF));
                        sb.append(StringExtensions.toHex(c >> 8 & 0xF));
                        sb.append(StringExtensions.toHex(c >> 4 & 0xF));
                        sb.append(StringExtensions.toHex(c & 0xF));
                        continue block8;
                    }
                    sb.append(c);
                }
            }
        }
        String returnString = sb.toString();
        if (toLowerCase) {
            return returnString.toLowerCase();
        }
        return returnString;
    }

    public static List<Character> newCharacterList(String input) {
        Objects.requireNonNull(input);
        return StringExtensions.newCharacterList(input, Comparator.naturalOrder());
    }

    public static List<Character> newCharacterList(String text, Comparator<Character> comparator) {
        Objects.requireNonNull(text);
        Objects.requireNonNull(comparator);
        return new ArrayList<Character>(text.chars().mapToObj(i -> Character.valueOf((char)i)).collect(Collectors.toCollection(() -> new TreeSet(comparator))));
    }

    public static String toString(List<Character> characterList) {
        StringBuilder sb = new StringBuilder();
        for (char ac : characterList) {
            sb.append(ac);
        }
        return sb.toString();
    }
}

