/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.design.pattern.state.button;

import io.github.astrapi69.design.pattern.state.button.ButtonState;
import lombok.NonNull;

public abstract class ButtonStateMachine<T, ST>
implements ButtonState<ST> {
    ButtonState<ST> current;
    @NonNull
    T button;

    protected abstract void updateButtonState();

    protected abstract void setEnabled(boolean var1);

    protected ButtonStateMachine(ButtonStateMachineBuilder<T, ST, ?, ?> b) {
        this.current = b.current;
        this.button = b.button;
        if (this.button == null) {
            throw new NullPointerException("button is marked non-null but is null");
        }
    }

    public ButtonState<ST> getCurrent() {
        return this.current;
    }

    @NonNull
    public T getButton() {
        return this.button;
    }

    public void setCurrent(ButtonState<ST> current) {
        this.current = current;
    }

    public void setButton(@NonNull T button) {
        if (button == null) {
            throw new NullPointerException("button is marked non-null but is null");
        }
        this.button = button;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ButtonStateMachine)) {
            return false;
        }
        ButtonStateMachine other = (ButtonStateMachine)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ButtonState<ST> this$current = this.getCurrent();
        ButtonState<ST> other$current = other.getCurrent();
        if (this$current == null ? other$current != null : !this$current.equals(other$current)) {
            return false;
        }
        T this$button = this.getButton();
        T other$button = other.getButton();
        return !(this$button == null ? other$button != null : !this$button.equals(other$button));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ButtonStateMachine;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ButtonState<ST> $current = this.getCurrent();
        result = result * 59 + ($current == null ? 43 : $current.hashCode());
        T $button = this.getButton();
        result = result * 59 + ($button == null ? 43 : $button.hashCode());
        return result;
    }

    public String toString() {
        return "ButtonStateMachine(current=" + this.getCurrent() + ", button=" + this.getButton() + ")";
    }

    public ButtonStateMachine() {
    }

    public ButtonStateMachine(ButtonState<ST> current, @NonNull T button) {
        if (button == null) {
            throw new NullPointerException("button is marked non-null but is null");
        }
        this.current = current;
        this.button = button;
    }

    public static abstract class ButtonStateMachineBuilder<T, ST, C extends ButtonStateMachine<T, ST>, B extends ButtonStateMachineBuilder<T, ST, C, B>> {
        private ButtonState<ST> current;
        private T button;

        protected abstract B self();

        public abstract C build();

        public B current(ButtonState<ST> current) {
            this.current = current;
            return this.self();
        }

        public B button(@NonNull T button) {
            if (button == null) {
                throw new NullPointerException("button is marked non-null but is null");
            }
            this.button = button;
            return this.self();
        }

        public String toString() {
            return "ButtonStateMachine.ButtonStateMachineBuilder(current=" + this.current + ", button=" + this.button + ")";
        }
    }
}

