/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.design.pattern.state.component;

import lombok.NonNull;

public abstract class ComponentStateMachine<C, S> {
    @NonNull
    C component;
    S currentState;

    protected abstract void updateComponentState();

    protected abstract void setEnabled(boolean var1);

    protected ComponentStateMachine(ComponentStateMachineBuilder<C, S, ?, ?> b) {
        this.component = b.component;
        if (this.component == null) {
            throw new NullPointerException("component is marked non-null but is null");
        }
        this.currentState = b.currentState;
    }

    @NonNull
    public C getComponent() {
        return this.component;
    }

    public S getCurrentState() {
        return this.currentState;
    }

    public void setComponent(@NonNull C component) {
        if (component == null) {
            throw new NullPointerException("component is marked non-null but is null");
        }
        this.component = component;
    }

    public void setCurrentState(S currentState) {
        this.currentState = currentState;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ComponentStateMachine)) {
            return false;
        }
        ComponentStateMachine other = (ComponentStateMachine)o;
        if (!other.canEqual(this)) {
            return false;
        }
        C this$component = this.getComponent();
        C other$component = other.getComponent();
        if (this$component == null ? other$component != null : !this$component.equals(other$component)) {
            return false;
        }
        S this$currentState = this.getCurrentState();
        S other$currentState = other.getCurrentState();
        return !(this$currentState == null ? other$currentState != null : !this$currentState.equals(other$currentState));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ComponentStateMachine;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        C $component = this.getComponent();
        result = result * 59 + ($component == null ? 43 : $component.hashCode());
        S $currentState = this.getCurrentState();
        result = result * 59 + ($currentState == null ? 43 : $currentState.hashCode());
        return result;
    }

    public String toString() {
        return "ComponentStateMachine(component=" + this.getComponent() + ", currentState=" + this.getCurrentState() + ")";
    }

    public ComponentStateMachine() {
    }

    public ComponentStateMachine(@NonNull C component, S currentState) {
        if (component == null) {
            throw new NullPointerException("component is marked non-null but is null");
        }
        this.component = component;
        this.currentState = currentState;
    }

    public static abstract class ComponentStateMachineBuilder<C, S, C2 extends ComponentStateMachine<C, S>, B extends ComponentStateMachineBuilder<C, S, C2, B>> {
        private C component;
        private S currentState;

        protected abstract B self();

        public abstract C2 build();

        public B component(@NonNull C component) {
            if (component == null) {
                throw new NullPointerException("component is marked non-null but is null");
            }
            this.component = component;
            return this.self();
        }

        public B currentState(S currentState) {
            this.currentState = currentState;
            return this.self();
        }

        public String toString() {
            return "ComponentStateMachine.ComponentStateMachineBuilder(component=" + this.component + ", currentState=" + this.currentState + ")";
        }
    }
}

