/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.swing.img;

import io.github.astrapi69.lang.ClassExtensions;
import io.github.astrapi69.swing.img.SvgImageTranscoder;
import io.github.astrapi69.throwable.RuntimeExceptionDecorator;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import org.apache.batik.anim.dom.SVGDOMImplementation;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscodingHints;
import org.apache.batik.transcoder.image.ImageTranscoder;

public class BatikImageIconFactory {
    public static ImageIcon newImageIconFromSVG(String imagePath, float targetWidth, float targetHeight) throws TranscoderException {
        return BatikImageIconFactory.newImageIconFromSVG(imagePath, targetWidth, targetHeight, null);
    }

    public static ImageIcon newImageIcon(File image) {
        return BatikImageIconFactory.newImageIcon(image, null);
    }

    public static ImageIcon newImageIcon(String relativeImagePath) {
        return BatikImageIconFactory.newImageIcon(relativeImagePath, true);
    }

    public static ImageIcon newImageIcon(String relativeImagePath, int newWidth, int newHeight) {
        return BatikImageIconFactory.newImageIcon(relativeImagePath, true, newWidth, newHeight);
    }

    public static ImageIcon newImageIcon(String imagePath, boolean relativePath) {
        return BatikImageIconFactory.newImageIcon(imagePath, relativePath, null);
    }

    public static ImageIcon newImageIcon(String imagePath, boolean relativePath, int newWidth, int newHeight) {
        return BatikImageIconFactory.newImageIcon(imagePath, relativePath, newWidth, newHeight, null);
    }

    public static ImageIcon newImageIcon(URL location) {
        return BatikImageIconFactory.newImageIcon(location, null);
    }

    public static ImageIcon newImageIcon(BufferedImage bufferedImage) {
        return BatikImageIconFactory.newImageIcon(bufferedImage, null);
    }

    public static ImageIcon newImageIcon(BufferedImage bufferedImage, String description) {
        return description == null ? new ImageIcon(bufferedImage) : new ImageIcon(bufferedImage, description);
    }

    public static ImageIcon newImageIcon(URL location, String description) {
        return description == null ? new ImageIcon(location) : new ImageIcon(location, description);
    }

    public static ImageIcon newImageIcon(String imagePath, boolean relativePath, int newWidth, int newHeight, String description) {
        if (relativePath) {
            BufferedImage bufferedImage = (BufferedImage)RuntimeExceptionDecorator.decorate(() -> ImageIO.read(ClassExtensions.getResourceAsStream((String)imagePath)));
            return new ImageIcon(bufferedImage.getScaledInstance(newWidth, newHeight, 1));
        }
        return description == null ? new ImageIcon(imagePath) : new ImageIcon(imagePath, description);
    }

    public static ImageIcon newImageIcon(String imagePath, boolean relativePath, String description) {
        if (relativePath) {
            BufferedImage bufferedImage = (BufferedImage)RuntimeExceptionDecorator.decorate(() -> ImageIO.read(ClassExtensions.getResourceAsStream((String)imagePath)));
            return new ImageIcon(bufferedImage);
        }
        return description == null ? new ImageIcon(imagePath) : new ImageIcon(imagePath, description);
    }

    public static ImageIcon newImageIcon(File image, String description) {
        return BatikImageIconFactory.newImageIcon(image.getAbsolutePath(), false, description);
    }

    public static ImageIcon newImageIconFromSVG(String imagePath, float targetWidth, float targetHeight, String description) throws TranscoderException {
        InputStream resourceAsStream = ClassExtensions.getResourceAsStream((String)imagePath);
        return BatikImageIconFactory.newImageIconFromSVG(resourceAsStream, targetWidth, targetHeight, description);
    }

    public static ImageIcon newImageIconFromSVG(InputStream svgImageAsStream, float targetWidth, float targetHeight, String description) throws TranscoderException {
        TranscoderInput input = new TranscoderInput(svgImageAsStream);
        SvgImageTranscoder transcoder = new SvgImageTranscoder();
        SVGDOMImplementation impl = (SVGDOMImplementation)SVGDOMImplementation.getDOMImplementation();
        TranscodingHints hints = new TranscodingHints();
        hints.put((Object)ImageTranscoder.KEY_WIDTH, (Object)Float.valueOf(targetWidth));
        hints.put((Object)ImageTranscoder.KEY_HEIGHT, (Object)Float.valueOf(targetHeight));
        hints.put((Object)ImageTranscoder.KEY_DOM_IMPLEMENTATION, (Object)impl.getDOMImplementation());
        hints.put((Object)ImageTranscoder.KEY_DOCUMENT_ELEMENT_NAMESPACE_URI, (Object)"http://www.w3.org/2000/svg");
        hints.put((Object)ImageTranscoder.KEY_DOCUMENT_ELEMENT, (Object)"svg");
        hints.put((Object)ImageTranscoder.KEY_XML_PARSER_VALIDATING, (Object)false);
        transcoder.setTranscodingHints(hints);
        transcoder.transcode(input, null);
        BufferedImage bufferedImage = transcoder.getImage();
        return description == null ? new ImageIcon(bufferedImage) : new ImageIcon(bufferedImage, description);
    }

    public static ImageIcon newImageIcon(String relativeImagePath, String description) {
        return BatikImageIconFactory.newImageIcon(relativeImagePath, true, description);
    }
}

