/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.swing.img;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.Image;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfWriter;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import lombok.Generated;

public class ImageToPdfExtensions {
    @Generated
    private static final Logger log = Logger.getLogger(ImageToPdfExtensions.class.getName());

    public static void createPdf(OutputStream result, List<BufferedImage> images) throws DocumentException, IOException {
        Document document = new Document();
        PdfWriter.getInstance((Document)document, (OutputStream)result);
        for (BufferedImage image : images) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)image, "png", baos);
            Image img = Image.getInstance((byte[])baos.toByteArray());
            document.setPageSize((Rectangle)img);
            document.newPage();
            img.setAbsolutePosition(0.0f, 0.0f);
            document.add((Element)img);
        }
        document.close();
    }

    public static PdfPTable newPdfPTable(int numColumns, List<String> headerNames) {
        PdfPTable table = new PdfPTable(numColumns);
        headerNames.stream().forEach(columnHeaderName -> {
            PdfPCell header = new PdfPCell();
            header.setBackgroundColor(BaseColor.LIGHT_GRAY);
            header.setBorderWidth(2.0f);
            header.setPhrase(new Phrase(columnHeaderName));
            table.addCell(header);
        });
        return table;
    }
}

