/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.swing.img;

import io.github.astrapi69.img.ImageExtensions;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import lombok.Generated;
import org.imgscalr.Scalr;

public class ResizeImageExtensions {
    @Generated
    private static final Logger log = Logger.getLogger(ResizeImageExtensions.class.getName());

    public static BufferedImage getResized(BufferedImage originalImage, Scalr.Method scalingMethod, Scalr.Mode resizeMode, String formatName, int targetWidth, int targetHeight) throws IOException {
        return ImageExtensions.read((byte[])ResizeImageExtensions.resize(originalImage, scalingMethod, resizeMode, formatName, targetWidth, targetHeight));
    }

    public static BufferedImage getResized(BufferedImage originalImage, String formatName, int targetWidth, int targetHeight) throws IOException {
        return ImageExtensions.read((byte[])ResizeImageExtensions.resize(originalImage, formatName, targetWidth, targetHeight));
    }

    public static BufferedImage readQuietly(InputStream input) {
        BufferedImage img = null;
        try {
            img = ImageIO.read(input);
        }
        catch (IOException e) {
            log.log(Level.SEVERE, "Reading image failed.", e);
        }
        return img;
    }

    public static byte[] resize(BufferedImage originalImage, Scalr.Method scalingMethod, Scalr.Mode resizeMode, String formatName, int targetWidth, int targetHeight) {
        try {
            BufferedImage resizedImage = Scalr.resize((BufferedImage)originalImage, (Scalr.Method)scalingMethod, (Scalr.Mode)resizeMode, (int)targetWidth, (int)targetHeight, (BufferedImageOp[])new BufferedImageOp[0]);
            return ImageExtensions.toByteArray((BufferedImage)resizedImage, (String)formatName);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static byte[] resize(BufferedImage originalImage, String formatName, int targetWidth, int targetHeight) {
        return ResizeImageExtensions.resize(originalImage, Scalr.Method.QUALITY, Scalr.Mode.FIT_EXACT, formatName, targetWidth, targetHeight);
    }
}

