/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.swing.list;

import io.github.astrapi69.collection.list.ListExtensions;
import io.github.astrapi69.collection.list.ListFactory;
import io.github.astrapi69.component.model.check.CheckableItem;
import io.github.astrapi69.component.model.check.CheckableValue;
import io.github.astrapi69.swing.renderer.tree.renderer.list.CheckBoxListRenderer;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.metal.MetalIconFactory;

public class JListExtensions {
    public static CheckableItem<CheckableValue>[] newCheckableItems(String[] strs) {
        int n = strs.length;
        List itemList = ListFactory.newArrayList((Object[])new CheckableItem[0]);
        for (int i = 0; i < n; ++i) {
            itemList.add(CheckableItem.builder().checkableValue((Object)CheckableValue.builder().itemText(strs[i]).build()).build());
        }
        return (CheckableItem[])ListExtensions.toArray((List)itemList);
    }

    public static JList<CheckableItem<CheckableValue>> newJList(String[] strs) {
        CheckableItem<CheckableValue>[] checkableItems = JListExtensions.newCheckableItems(strs);
        return JListExtensions.newJList(checkableItems);
    }

    public static JList<CheckableItem<CheckableValue>> newJList(CheckableItem<CheckableValue>[] checkableItems) {
        final JList<CheckableItem<CheckableValue>> list = new JList<CheckableItem<CheckableValue>>(checkableItems);
        Icon icon = MetalIconFactory.getFileChooserHomeFolderIcon();
        ((CheckableValue)list.getModel().getElementAt(1).getCheckableValue()).setIcon(icon);
        list.setCellRenderer((ListCellRenderer<CheckableItem<CheckableValue>>)new CheckBoxListRenderer());
        list.setSelectionMode(0);
        list.setBorder(new EmptyBorder(0, 4, 0, 0));
        list.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                CheckableItem item;
                int index = list.locationToIndex(e.getPoint());
                item.setSelected(!(item = (CheckableItem)list.getModel().getElementAt(index)).isSelected());
                Rectangle rect = list.getCellBounds(index, index);
                list.repaint(rect);
            }
        });
        return list;
    }
}

