/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.swing.panel.lottery;

import io.github.astrapi69.icon.StringIcon;
import io.github.astrapi69.model.BaseModel;
import io.github.astrapi69.model.api.IModel;
import io.github.astrapi69.swing.base.BasePanel;
import io.github.astrapi69.swing.panel.lottery.LotteryBox;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;

public class LotteryPanel
extends BasePanel<LotteryBox>
implements ActionListener {
    private LinkedHashMap<Integer, JCheckBox> lotteryBoxes;

    public LotteryPanel() {
        this((IModel<LotteryBox>)BaseModel.of((Object)LotteryBox.builder().selectedNumbers(new LinkedHashSet<Integer>()).build()));
    }

    public LotteryPanel(IModel<LotteryBox> model) {
        super(model);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        LinkedHashSet<Integer> selectedNumbers = ((LotteryBox)this.getModelObject()).getSelectedNumbers();
        JCheckBox source = (JCheckBox)e.getSource();
        boolean selected = source.isSelected();
        StringIcon icon = (StringIcon)source.getIcon();
        Integer selectedNumber = Integer.valueOf(icon.getText().trim());
        if (selected) {
            selectedNumbers.add(selectedNumber);
        } else {
            selectedNumbers.remove(selectedNumber);
        }
        if (selectedNumbers.size() == ((LotteryBox)this.getModelObject()).getMaxNumbers()) {
            this.lotteryBoxes.entrySet().stream().filter(entry -> !selectedNumbers.contains(entry.getKey())).map(Map.Entry::getValue).forEach(cb -> cb.setEnabled(false));
            this.revalidate();
        } else {
            this.lotteryBoxes.values().forEach(cb -> {
                if (!cb.isEnabled()) {
                    cb.setEnabled(true);
                }
            });
        }
    }

    protected void onInitializeComponents() {
        this.lotteryBoxes = new LinkedHashMap();
        for (int i = ((LotteryBox)this.getModelObject()).getMinVolume(); i <= ((LotteryBox)this.getModelObject()).getMaxVolume(); i += ((LotteryBox)this.getModelObject()).getStep()) {
            StringIcon icon = new StringIcon((JComponent)((Object)this), Integer.valueOf(i).toString());
            JCheckBox checkBox = new JCheckBox((Icon)icon);
            checkBox.addActionListener(this);
            checkBox.setBorderPainted(true);
            this.lotteryBoxes.put(i, checkBox);
            this.add(checkBox);
        }
    }

    protected void onInitializeLayout() {
        this.setLayout(new GridLayout(((LotteryBox)this.getModelObject()).getRows(), ((LotteryBox)this.getModelObject()).getColumns()));
    }
}

