/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.swing.model.component;

import io.github.astrapi69.swing.document.RegularExpressionDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import lombok.NonNull;

public class DecimalNumberValuesDocument
extends RegularExpressionDocument {
    private static final long serialVersionUID = 1L;
    public static final String DEFAULT_REGEX = "^-?\\d*(\\.\\d*)?$";

    public DecimalNumberValuesDocument() {
        this(DEFAULT_REGEX);
    }

    public DecimalNumberValuesDocument(@NonNull String regex) {
        super(regex);
        if (regex == null) {
            throw new NullPointerException("regex is marked non-null but is null");
        }
    }

    public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
        String currentText = this.getText(0, this.getLength());
        String proposedValue = currentText.substring(0, offs) + str + currentText.substring(offs);
        if (proposedValue.matches(DEFAULT_REGEX)) {
            super.insertString(offs, str, a);
        }
    }

    public void replace(int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
        String currentText = this.getText(0, this.getLength());
        String proposedValue = currentText.substring(0, offset) + text + currentText.substring(offset + length);
        if (proposedValue.matches(DEFAULT_REGEX)) {
            super.replace(offset, length, text, attrs);
        }
    }

    public String validate(String proposedValue) throws IllegalArgumentException {
        if (proposedValue.isEmpty() || proposedValue.matches(DEFAULT_REGEX)) {
            return proposedValue;
        }
        throw new IllegalArgumentException("Value does not match the required format");
    }
}

