/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.swing.model.component;

import io.github.astrapi69.model.api.IModel;
import io.github.astrapi69.swing.listener.document.DocumentListenerAdapter;
import io.github.astrapi69.swing.model.component.DecimalNumberValuesDocument;
import io.github.astrapi69.swing.model.component.JMGenericTextField;
import io.github.astrapi69.throwable.RuntimeExceptionDecorator;
import java.math.BigDecimal;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import lombok.Generated;
import lombok.NonNull;

public class JMBigDecimalTextField
extends JMGenericTextField<BigDecimal> {
    public JMBigDecimalTextField(@NonNull IModel<BigDecimal> propertyModel) {
        super(propertyModel);
        if (propertyModel == null) {
            throw new NullPointerException("propertyModel is marked non-null but is null");
        }
    }

    public JMBigDecimalTextField() {
    }

    public JMBigDecimalTextField(String text) {
        super(text);
    }

    public JMBigDecimalTextField(String text, int columns) {
        super(text, columns);
    }

    public JMBigDecimalTextField(int columns) {
        super(columns);
    }

    @Override
    protected void onInitialize() {
        this.setDocument((Document)((Object)new DecimalNumberValuesDocument()));
        this.getDocument().addDocumentListener((DocumentListener)new DocumentListenerAdapter(){

            public void onDocumentChanged(DocumentEvent documentEvent) {
                int currentLength = documentEvent.getDocument().getLength();
                String text = (String)RuntimeExceptionDecorator.decorate(() -> documentEvent.getDocument().getText(0, currentLength));
                if (JMBigDecimalTextField.this.getPropertyModel() != null) {
                    JMBigDecimalTextField.this.getPropertyModel().setObject((Object)JMBigDecimalTextField.this.toGenericObject(text));
                }
            }
        });
    }

    @Override
    public BigDecimal toGenericObject(String text) {
        if (text == null || text.isEmpty()) {
            return BigDecimal.ZERO;
        }
        return new BigDecimal(text);
    }

    @Override
    public String toText(BigDecimal propertyModelObject) {
        return propertyModelObject != null ? propertyModelObject.toString() : "";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JMBigDecimalTextField)) {
            return false;
        }
        JMBigDecimalTextField other = (JMBigDecimalTextField)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof JMBigDecimalTextField;
    }

    @Override
    @Generated
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

