/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.swing.model.component;

import io.github.astrapi69.model.api.IModel;
import io.github.astrapi69.swing.document.NumberValuesDocument;
import io.github.astrapi69.swing.listener.document.DocumentListenerAdapter;
import io.github.astrapi69.swing.model.component.JMGenericTextField;
import io.github.astrapi69.throwable.RuntimeExceptionDecorator;
import java.math.BigInteger;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import lombok.Generated;
import lombok.NonNull;

public class JMBigIntegerTextField
extends JMGenericTextField<BigInteger> {
    public JMBigIntegerTextField(@NonNull IModel<BigInteger> propertyModel) {
        super(propertyModel);
        if (propertyModel == null) {
            throw new NullPointerException("propertyModel is marked non-null but is null");
        }
    }

    public JMBigIntegerTextField() {
    }

    public JMBigIntegerTextField(String text) {
        super(text);
    }

    public JMBigIntegerTextField(String text, int columns) {
        super(text, columns);
    }

    public JMBigIntegerTextField(int columns) {
        super(columns);
    }

    @Override
    protected void onInitialize() {
        this.setDocument((Document)new NumberValuesDocument());
        this.getDocument().addDocumentListener((DocumentListener)new DocumentListenerAdapter(){

            public void onDocumentChanged(DocumentEvent documentEvent) {
                int currentLength = documentEvent.getDocument().getLength();
                String text = (String)RuntimeExceptionDecorator.decorate(() -> documentEvent.getDocument().getText(0, currentLength));
                if (JMBigIntegerTextField.this.getPropertyModel() != null) {
                    JMBigIntegerTextField.this.getPropertyModel().setObject((Object)JMBigIntegerTextField.this.toGenericObject(text));
                }
            }
        });
    }

    @Override
    public BigInteger toGenericObject(String text) {
        if (text == null || text.isEmpty()) {
            return BigInteger.ZERO;
        }
        return new BigInteger(text);
    }

    @Override
    public String toText(BigInteger propertyModelObject) {
        return propertyModelObject != null ? propertyModelObject.toString() : "";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JMBigIntegerTextField)) {
            return false;
        }
        JMBigIntegerTextField other = (JMBigIntegerTextField)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof JMBigIntegerTextField;
    }

    @Override
    @Generated
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

