/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.swing.model.component;

import io.github.astrapi69.model.BaseModel;
import io.github.astrapi69.model.api.IModel;
import javax.swing.JTextField;
import lombok.Generated;
import lombok.NonNull;

public abstract class JMGenericTextField<T>
extends JTextField {
    private IModel<T> propertyModel = BaseModel.of();

    public JMGenericTextField(@NonNull IModel<T> propertyModel) {
        this.onInitialize();
        if (propertyModel == null) {
            throw new NullPointerException("propertyModel is marked non-null but is null");
        }
        this.propertyModel = propertyModel;
    }

    public JMGenericTextField() {
        this("");
    }

    public JMGenericTextField(String text) {
        super(text);
        this.onInitialize();
        this.propertyModel.setObject(this.toGenericObject(text));
    }

    public JMGenericTextField(String text, int columns) {
        super(text, columns);
        this.onInitialize();
        this.propertyModel.setObject(this.toGenericObject(text));
    }

    public JMGenericTextField(int columns) {
        this("", columns);
    }

    public JMGenericTextField setPropertyModel(@NonNull IModel<T> propertyModel) {
        if (propertyModel == null) {
            throw new NullPointerException("propertyModel is marked non-null but is null");
        }
        this.propertyModel = propertyModel;
        this.setText(this.toText(this.propertyModel.getObject()));
        return this;
    }

    protected abstract void onInitialize();

    public abstract T toGenericObject(String var1);

    public abstract String toText(T var1);

    @Generated
    public IModel<T> getPropertyModel() {
        return this.propertyModel;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JMGenericTextField)) {
            return false;
        }
        JMGenericTextField other = (JMGenericTextField)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IModel<T> this$propertyModel = this.getPropertyModel();
        IModel<T> other$propertyModel = other.getPropertyModel();
        return !(this$propertyModel == null ? other$propertyModel != null : !this$propertyModel.equals(other$propertyModel));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof JMGenericTextField;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        IModel<T> $propertyModel = this.getPropertyModel();
        result = result * 59 + ($propertyModel == null ? 43 : $propertyModel.hashCode());
        return result;
    }
}

