/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.swing.model.component;

import io.github.astrapi69.model.BaseModel;
import io.github.astrapi69.model.api.IModel;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JSpinner;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.text.DefaultFormatter;
import lombok.NonNull;

public class JMSpinner<T>
extends JSpinner {
    IModel<T> propertyModel = BaseModel.of();

    public JMSpinner(SpinnerModel model) {
        super(model);
        JComponent comp = this.getEditor();
        JFormattedTextField field = (JFormattedTextField)comp.getComponent(0);
        DefaultFormatter formatter = (DefaultFormatter)field.getFormatter();
        formatter.setCommitsOnValidEdit(true);
        this.addChangeListener(e -> {
            JSpinner s = (JSpinner)e.getSource();
            Object value = s.getValue();
            this.propertyModel.setObject(value);
        });
    }

    public JMSpinner() {
        JComponent comp = this.getEditor();
        JFormattedTextField field = (JFormattedTextField)comp.getComponent(0);
        DefaultFormatter formatter = (DefaultFormatter)field.getFormatter();
        formatter.setCommitsOnValidEdit(true);
        this.addChangeListener(e -> {
            JSpinner s = (JSpinner)e.getSource();
            Object value = s.getValue();
            this.propertyModel.setObject(value);
        });
    }

    public JMSpinner(int value, int minimum, int maximum, int stepSize) {
        super(new SpinnerNumberModel(value, minimum, maximum, stepSize));
        JComponent comp = this.getEditor();
        JFormattedTextField field = (JFormattedTextField)comp.getComponent(0);
        DefaultFormatter formatter = (DefaultFormatter)field.getFormatter();
        formatter.setCommitsOnValidEdit(true);
        this.addChangeListener(e -> {
            JSpinner s = (JSpinner)e.getSource();
            Object value = s.getValue();
            this.propertyModel.setObject(value);
        });
    }

    public JMSpinner(SpinnerModel model, IModel<T> propertyModel) {
        super(model);
        JComponent comp = this.getEditor();
        JFormattedTextField field = (JFormattedTextField)comp.getComponent(0);
        DefaultFormatter formatter = (DefaultFormatter)field.getFormatter();
        formatter.setCommitsOnValidEdit(true);
        this.addChangeListener(e -> {
            JSpinner s = (JSpinner)e.getSource();
            Object value = s.getValue();
            this.propertyModel.setObject(value);
        });
        this.propertyModel = propertyModel;
        this.getModel().setValue(this.propertyModel.getObject());
    }

    public JMSpinner<T> setPropertyModel(@NonNull IModel<T> propertyModel) {
        if (propertyModel == null) {
            throw new NullPointerException("propertyModel is marked non-null but is null");
        }
        this.propertyModel = propertyModel;
        this.getModel().setValue(this.propertyModel.getObject());
        return this;
    }
}

