/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.swing.model.component;

import io.github.astrapi69.model.api.IModel;
import io.github.astrapi69.swing.listener.document.DocumentListenerAdapter;
import io.github.astrapi69.swing.model.component.JMGenericTextField;
import io.github.astrapi69.throwable.RuntimeExceptionDecorator;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import lombok.Generated;
import lombok.NonNull;

public class JMStringTextField
extends JMGenericTextField<String> {
    public JMStringTextField(@NonNull IModel<String> propertyModel) {
        super(propertyModel);
        if (propertyModel == null) {
            throw new NullPointerException("propertyModel is marked non-null but is null");
        }
    }

    public JMStringTextField() {
    }

    public JMStringTextField(String text) {
        super(text);
    }

    public JMStringTextField(String text, int columns) {
        super(text, columns);
    }

    public JMStringTextField(int columns) {
        this.setColumns(columns);
    }

    @Override
    protected void onInitialize() {
        this.getDocument().addDocumentListener((DocumentListener)new DocumentListenerAdapter(){

            public void onDocumentChanged(DocumentEvent documentEvent) {
                int currentLength = documentEvent.getDocument().getLength();
                String text = (String)RuntimeExceptionDecorator.decorate(() -> documentEvent.getDocument().getText(0, currentLength));
                if (JMStringTextField.this.getPropertyModel() != null) {
                    JMStringTextField.this.getPropertyModel().setObject((Object)JMStringTextField.this.toGenericObject(text));
                }
            }
        });
    }

    @Override
    public String toGenericObject(String text) {
        return text;
    }

    @Override
    public String toText(String propertyModelObject) {
        return propertyModelObject;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JMStringTextField)) {
            return false;
        }
        JMStringTextField other = (JMStringTextField)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof JMStringTextField;
    }

    @Override
    @Generated
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

