/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.swing.renderer.tree;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;

public class GenericTreeElement<T>
implements Serializable {
    public static final String DEFAULT_CONTENT_KEY = "default_content";
    private static final long serialVersionUID = 1L;
    private Map<String, Object> properties;
    private String name;
    private boolean leaf;
    private boolean withText;
    private String iconPath;
    private String selectedIconPath;

    public Map<String, Object> getProperties() {
        if (this.properties == null) {
            this.properties = new LinkedHashMap<String, Object>();
        }
        return this.properties;
    }

    public T getDefaultContent() {
        return (T)this.getProperties().get(DEFAULT_CONTENT_KEY);
    }

    public GenericTreeElement<T> setDefaultContent(T defaultContent) {
        this.getProperties().put(DEFAULT_CONTENT_KEY, defaultContent);
        return this;
    }

    public static <T> GenericTreeElementBuilder<T> builder() {
        return new GenericTreeElementBuilder();
    }

    public GenericTreeElementBuilder<T> toBuilder() {
        return new GenericTreeElementBuilder().properties(this.properties).name(this.name).leaf(this.leaf).withText(this.withText).iconPath(this.iconPath).selectedIconPath(this.selectedIconPath);
    }

    public String getName() {
        return this.name;
    }

    public boolean isLeaf() {
        return this.leaf;
    }

    public boolean isWithText() {
        return this.withText;
    }

    public String getIconPath() {
        return this.iconPath;
    }

    public String getSelectedIconPath() {
        return this.selectedIconPath;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setLeaf(boolean leaf) {
        this.leaf = leaf;
    }

    public void setWithText(boolean withText) {
        this.withText = withText;
    }

    public void setIconPath(String iconPath) {
        this.iconPath = iconPath;
    }

    public void setSelectedIconPath(String selectedIconPath) {
        this.selectedIconPath = selectedIconPath;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GenericTreeElement)) {
            return false;
        }
        GenericTreeElement other = (GenericTreeElement)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isLeaf() != other.isLeaf()) {
            return false;
        }
        if (this.isWithText() != other.isWithText()) {
            return false;
        }
        Map<String, Object> this$properties = this.getProperties();
        Map<String, Object> other$properties = other.getProperties();
        if (this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$iconPath = this.getIconPath();
        String other$iconPath = other.getIconPath();
        if (this$iconPath == null ? other$iconPath != null : !this$iconPath.equals(other$iconPath)) {
            return false;
        }
        String this$selectedIconPath = this.getSelectedIconPath();
        String other$selectedIconPath = other.getSelectedIconPath();
        return !(this$selectedIconPath == null ? other$selectedIconPath != null : !this$selectedIconPath.equals(other$selectedIconPath));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GenericTreeElement;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isLeaf() ? 79 : 97);
        result = result * 59 + (this.isWithText() ? 79 : 97);
        Map<String, Object> $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $iconPath = this.getIconPath();
        result = result * 59 + ($iconPath == null ? 43 : $iconPath.hashCode());
        String $selectedIconPath = this.getSelectedIconPath();
        result = result * 59 + ($selectedIconPath == null ? 43 : $selectedIconPath.hashCode());
        return result;
    }

    public String toString() {
        return "GenericTreeElement(properties=" + this.getProperties() + ", name=" + this.getName() + ", leaf=" + this.isLeaf() + ", withText=" + this.isWithText() + ", iconPath=" + this.getIconPath() + ", selectedIconPath=" + this.getSelectedIconPath() + ")";
    }

    public GenericTreeElement() {
    }

    public GenericTreeElement(Map<String, Object> properties, String name, boolean leaf, boolean withText, String iconPath, String selectedIconPath) {
        this.properties = properties;
        this.name = name;
        this.leaf = leaf;
        this.withText = withText;
        this.iconPath = iconPath;
        this.selectedIconPath = selectedIconPath;
    }

    public static class GenericTreeElementBuilder<T> {
        private Map<String, Object> properties;
        private String name;
        private boolean leaf;
        private boolean withText;
        private String iconPath;
        private String selectedIconPath;

        GenericTreeElementBuilder() {
        }

        public GenericTreeElementBuilder<T> properties(Map<String, Object> properties) {
            this.properties = properties;
            return this;
        }

        public GenericTreeElementBuilder<T> name(String name) {
            this.name = name;
            return this;
        }

        public GenericTreeElementBuilder<T> leaf(boolean leaf) {
            this.leaf = leaf;
            return this;
        }

        public GenericTreeElementBuilder<T> withText(boolean withText) {
            this.withText = withText;
            return this;
        }

        public GenericTreeElementBuilder<T> iconPath(String iconPath) {
            this.iconPath = iconPath;
            return this;
        }

        public GenericTreeElementBuilder<T> selectedIconPath(String selectedIconPath) {
            this.selectedIconPath = selectedIconPath;
            return this;
        }

        public GenericTreeElement<T> build() {
            return new GenericTreeElement(this.properties, this.name, this.leaf, this.withText, this.iconPath, this.selectedIconPath);
        }

        public String toString() {
            return "GenericTreeElement.GenericTreeElementBuilder(properties=" + this.properties + ", name=" + this.name + ", leaf=" + this.leaf + ", withText=" + this.withText + ", iconPath=" + this.iconPath + ", selectedIconPath=" + this.selectedIconPath + ")";
        }
    }
}

