/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.swing.renderer.tree.renderer;

import io.github.astrapi69.gen.tree.BaseTreeNode;
import io.github.astrapi69.icon.ImageIconFactory;
import io.github.astrapi69.icon.StringIcon;
import io.github.astrapi69.swing.renderer.tree.GenericTreeElement;
import io.github.astrapi69.swing.renderer.tree.renderer.BaseTreeNodeCellRenderer;
import java.awt.Color;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.apache.commons.lang3.StringUtils;

public class GenericBaseTreeNodeCellRenderer<T, K>
extends BaseTreeNodeCellRenderer<GenericTreeElement<T>, K> {
    Icon customTreeIcon;
    Icon selectedTreeIcon;

    @Override
    protected JLabel initialize(BaseTreeNode<GenericTreeElement<T>, K> userObject) {
        String iconPath;
        BaseTreeNode<GenericTreeElement<T>, K> treeNode = userObject;
        String displayValue = treeNode.getDisplayValue();
        GenericTreeElement value = (GenericTreeElement)treeNode.getValue();
        if (value != null && StringUtils.isNotEmpty((CharSequence)(iconPath = value.getIconPath()))) {
            this.initializeCustomTreeIcon(value);
            this.initializeSelectedTreeIcon(value);
            if (value.isWithText()) {
                this.setText(displayValue);
            } else {
                this.setText("");
            }
            this.setToolTipText(displayValue);
            this.setIcon(this.customTreeIcon);
            return this;
        }
        return super.initialize(userObject);
    }

    protected void initializeCustomTreeIcon(GenericTreeElement<T> value) {
        String iconPath = value.getIconPath();
        if (StringUtils.isNotEmpty((CharSequence)iconPath)) {
            try {
                this.customTreeIcon = ImageIconFactory.newImageIcon((String)iconPath);
            }
            catch (Exception e) {
                this.customTreeIcon = new StringIcon((JComponent)this, iconPath);
            }
        }
    }

    protected void initializeSelectedTreeIcon(GenericTreeElement<T> value) {
        String selectedIconPath = value.getSelectedIconPath();
        if (StringUtils.isNotEmpty((CharSequence)selectedIconPath)) {
            try {
                this.selectedTreeIcon = ImageIconFactory.newImageIcon((String)selectedIconPath);
            }
            catch (Exception e) {
                JLabel selectedTreeLabel = new JLabel(this.getText());
                selectedTreeLabel.setForeground(Color.blue);
                selectedTreeLabel.setBackground(Color.black);
                this.selectedTreeIcon = new StringIcon((JComponent)selectedTreeLabel, selectedIconPath);
            }
        }
    }

    @Override
    public Icon getOpenIcon() {
        return this.renderer.getOpenIcon();
    }

    @Override
    public Icon getLeafIcon() {
        return this.renderer.getLeafIcon();
    }

    @Override
    public Icon getClosedIcon() {
        return this.renderer.getClosedIcon();
    }
}

