/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.swing.renderer.tree.renderer;

import io.github.astrapi69.gen.tree.BaseTreeNode;
import io.github.astrapi69.icon.ImageIconFactory;
import io.github.astrapi69.icon.StringIcon;
import io.github.astrapi69.swing.renderer.tree.JTreeElement;
import io.github.astrapi69.swing.renderer.tree.renderer.BaseTreeNodeCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.apache.commons.lang3.StringUtils;

public class JBaseTreeNodeCellRenderer
extends BaseTreeNodeCellRenderer<JTreeElement, Long> {
    @Override
    protected JLabel initialize(BaseTreeNode<JTreeElement, Long> userObject) {
        String iconPath;
        BaseTreeNode<JTreeElement, Long> treeNode = userObject;
        String displayValue = treeNode.getDisplayValue();
        JTreeElement value = (JTreeElement)treeNode.getValue();
        if (value != null && StringUtils.isNotEmpty((CharSequence)(iconPath = value.getIconPath()))) {
            ImageIcon customTreeIcon;
            try {
                customTreeIcon = ImageIconFactory.newImageIcon((String)iconPath);
            }
            catch (Exception e) {
                customTreeIcon = new StringIcon((JComponent)this, iconPath);
            }
            if (value.isWithText()) {
                this.setText(displayValue);
            } else {
                this.setText("");
            }
            this.setToolTipText(displayValue);
            this.setIcon(customTreeIcon);
            return this;
        }
        return super.initialize(userObject);
    }

    @Override
    public Icon getOpenIcon() {
        return this.renderer.getOpenIcon();
    }

    @Override
    public Icon getLeafIcon() {
        return this.renderer.getLeafIcon();
    }

    @Override
    public Icon getClosedIcon() {
        return this.renderer.getClosedIcon();
    }
}

