/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.swing.renderer.tree.renderer;

import io.github.astrapi69.gen.tree.TreeNode;
import io.github.astrapi69.icon.ImageIconFactory;
import io.github.astrapi69.icon.StringIcon;
import io.github.astrapi69.swing.renderer.tree.JTreeElement;
import io.github.astrapi69.swing.renderer.tree.renderer.TreeNodeCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.apache.commons.lang3.StringUtils;

public class JTreeNodeCellRenderer
extends TreeNodeCellRenderer<JTreeElement> {
    @Override
    protected JLabel initialize(TreeNode<JTreeElement> userObject) {
        String iconPath;
        TreeNode<JTreeElement> treeNode = userObject;
        String displayValue = treeNode.getDisplayValue();
        JTreeElement value = (JTreeElement)treeNode.getValue();
        if (value != null && StringUtils.isNotEmpty((CharSequence)(iconPath = value.getIconPath()))) {
            ImageIcon customTreeIcon;
            try {
                customTreeIcon = ImageIconFactory.newImageIcon((String)iconPath);
            }
            catch (Exception e) {
                customTreeIcon = new StringIcon((JComponent)this.treeLabel, iconPath);
            }
            if (value.isWithText()) {
                this.treeLabel.setText(displayValue);
            } else {
                this.treeLabel.setText("");
            }
            this.treeLabel.setToolTipText(displayValue);
            this.treeLabel.setIcon(customTreeIcon);
            return this.treeLabel;
        }
        return super.initialize(userObject);
    }

    @Override
    public Icon getOpenIcon() {
        return this.renderer.getOpenIcon();
    }

    @Override
    public Icon getLeafIcon() {
        return this.renderer.getLeafIcon();
    }

    @Override
    public Icon getClosedIcon() {
        return this.renderer.getClosedIcon();
    }
}

