/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.swing.renderer.tree.renderer;

import io.github.astrapi69.gen.tree.TreeNode;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;

public class TreeNodeCellRenderer<T>
extends DefaultTreeCellRenderer {
    protected final DefaultTreeCellRenderer renderer = new DefaultTreeCellRenderer();
    protected final JLabel treeLabel = new JLabel("init-tree-label");

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        DefaultMutableTreeNode node;
        Object userObject;
        if (value instanceof TreeNode) {
            return this.initialize((TreeNode)value);
        }
        if (value instanceof DefaultMutableTreeNode && (userObject = (node = (DefaultMutableTreeNode)value).getUserObject()) instanceof TreeNode) {
            return this.initialize((TreeNode)userObject);
        }
        return this.renderer.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
    }

    protected JLabel initialize(TreeNode<T> userObject) {
        TreeNode<T> treeNode = userObject;
        String displayValue = treeNode.getDisplayValue();
        this.treeLabel.setText(displayValue);
        if (treeNode.isLeaf()) {
            this.treeLabel.setIcon(this.getLeafIcon());
        } else if (treeNode.hasChildren()) {
            this.treeLabel.setIcon(this.getOpenIcon());
        } else {
            this.treeLabel.setIcon(this.getClosedIcon());
        }
        return this.treeLabel;
    }

    @Override
    public Icon getOpenIcon() {
        return this.renderer.getOpenIcon();
    }

    @Override
    public Icon getLeafIcon() {
        return this.renderer.getLeafIcon();
    }

    @Override
    public Icon getClosedIcon() {
        return this.renderer.getClosedIcon();
    }
}

