/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.swing.renderer.tree.renderer.state;

import io.github.astrapi69.gen.tree.BaseTreeNode;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;

public class AbstractBaseTreeNodeCellRenderer<T, K>
extends DefaultTreeCellRenderer {
    protected final DefaultTreeCellRenderer renderer = new DefaultTreeCellRenderer();

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        DefaultMutableTreeNode node;
        Object userObject;
        if (value instanceof BaseTreeNode) {
            BaseTreeNode baseTreeNode = (BaseTreeNode)value;
            return this.initialize(tree, baseTreeNode, selected, expanded, leaf, row, hasFocus);
        }
        if (value instanceof DefaultMutableTreeNode && (userObject = (node = (DefaultMutableTreeNode)value).getUserObject()) instanceof BaseTreeNode) {
            BaseTreeNode baseTreeNode = (BaseTreeNode)userObject;
            return this.initialize(tree, baseTreeNode, selected, expanded, leaf, row, hasFocus);
        }
        return this.renderer.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
    }

    protected JLabel initialize(JTree tree, BaseTreeNode<T, K> userObject, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        JLabel treeLabel = new JLabel("init-tree-label");
        BaseTreeNode<T, K> treeNode = userObject;
        String displayValue = treeNode.getDisplayValue();
        treeLabel.setText(displayValue);
        if (treeNode.isLeaf()) {
            treeLabel.setIcon(this.getLeafIcon());
        } else if (treeNode.hasChildren()) {
            treeLabel.setIcon(this.getOpenIcon());
        } else {
            treeLabel.setIcon(this.getClosedIcon());
        }
        return treeLabel;
    }

    @Override
    public Icon getOpenIcon() {
        return this.renderer.getOpenIcon();
    }

    @Override
    public Icon getLeafIcon() {
        return this.renderer.getLeafIcon();
    }

    @Override
    public Icon getClosedIcon() {
        return this.renderer.getClosedIcon();
    }
}

