/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.swing.renderer.tree.renderer.state;

import io.github.astrapi69.gen.tree.BaseTreeNode;
import io.github.astrapi69.icon.ImageIconFactory;
import io.github.astrapi69.icon.StringIcon;
import io.github.astrapi69.swing.renderer.tree.GenericTreeElement;
import io.github.astrapi69.swing.renderer.tree.renderer.state.AbstractBaseTreeNodeCellRenderer;
import io.github.astrapi69.swing.renderer.tree.renderer.state.TreeCellRendererState;
import java.awt.Color;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTree;
import org.apache.commons.lang3.StringUtils;

public class NewGenericBaseTreeNodeCellRenderer<T, K>
extends AbstractBaseTreeNodeCellRenderer<GenericTreeElement<T>, K> {
    Map<String, Icon> iconCacheMap = new LinkedHashMap<String, Icon>();

    @Override
    protected JLabel initialize(JTree tree, BaseTreeNode<GenericTreeElement<T>, K> treeNode, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        JLabel treeLabel = new JLabel("");
        String displayValue = treeNode.getDisplayValue();
        treeLabel.setText(displayValue);
        GenericTreeElement value = (GenericTreeElement)treeNode.getValue();
        if (value != null) {
            TreeCellRendererState renderState = TreeCellRendererState.getRenderState(treeNode.isLeaf(), selected, expanded, hasFocus, treeNode.hasChildren());
            Icon customTreeIcon = this.initializeCustomTreeIcon(value);
            Icon selectedTreeIcon = this.initializeSelectedTreeIcon(value);
            switch (renderState) {
                case LEAF: 
                case SELECTED_LEAF: 
                case SELECTED_FOCUSED_LEAF: {
                    treeLabel.setIcon(this.getLeafIcon());
                    break;
                }
                case SELECTED_NODE: 
                case SELECTED_FOCUSED_NODE: 
                case SELECTED_NODE_WITH_CHILDREN: 
                case SELECTED_FOCUSED_NODE_WITH_CHILDREN: 
                case EXPANDED_SELECTED_NODE: 
                case EXPANDED_SELECTED_FOCUSED_NODE: 
                case EXPANDED_SELECTED_NODE_WITH_CHILDREN: 
                case EXPANDED_SELECTED_FOCUSED_NODE_WITH_CHILDREN: {
                    treeLabel.setText(displayValue);
                    treeLabel.setIcon(selectedTreeIcon == null ? (customTreeIcon == null ? this.getOpenIcon() : customTreeIcon) : selectedTreeIcon);
                    break;
                }
                default: {
                    treeLabel.setText(displayValue);
                    treeLabel.setIcon(customTreeIcon == null ? this.getOpenIcon() : customTreeIcon);
                }
            }
            String iconPath = value.getIconPath();
            if (!value.isWithText() && iconPath != null) {
                treeLabel.setText("");
            }
            treeLabel.setForeground(selected ? this.getSelectedLabelForeground() : this.getLabelForeground());
            treeLabel.setToolTipText(displayValue);
            return treeLabel;
        }
        return super.initialize(tree, treeNode, selected, expanded, leaf, row, hasFocus);
    }

    protected Icon initializeCustomTreeIcon(GenericTreeElement<T> value) {
        String iconPath = value.getIconPath();
        if (!this.iconCacheMap.containsKey(iconPath) && StringUtils.isNotEmpty((CharSequence)iconPath)) {
            ImageIcon customTreeIcon;
            try {
                customTreeIcon = ImageIconFactory.newImageIcon((String)iconPath);
            }
            catch (Exception e) {
                customTreeIcon = new StringIcon((JComponent)this, value.getName());
            }
            this.iconCacheMap.put(iconPath, customTreeIcon);
        }
        return this.iconCacheMap.get(iconPath);
    }

    protected Icon initializeSelectedTreeIcon(GenericTreeElement<T> value) {
        String selectedIconPath = value.getSelectedIconPath();
        if (!this.iconCacheMap.containsKey(selectedIconPath) && StringUtils.isNotEmpty((CharSequence)selectedIconPath)) {
            ImageIcon customTreeIcon;
            try {
                customTreeIcon = ImageIconFactory.newImageIcon((String)selectedIconPath);
            }
            catch (Exception e) {
                customTreeIcon = new StringIcon((JComponent)this, value.getName());
            }
            this.iconCacheMap.put(selectedIconPath, customTreeIcon);
        }
        return this.iconCacheMap.get(selectedIconPath);
    }

    @Override
    public Icon getOpenIcon() {
        return this.renderer.getOpenIcon();
    }

    @Override
    public Icon getLeafIcon() {
        return this.renderer.getLeafIcon();
    }

    @Override
    public Icon getClosedIcon() {
        return this.renderer.getClosedIcon();
    }

    protected Color getSelectedLabelForeground() {
        return Color.blue;
    }

    protected Color getLabelForeground() {
        return Color.black;
    }
}

