/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.swing.renderer.tree.renderer.state;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;

public enum SimpleTreeCellRendererState {
    LEAF,
    SELECTED_LEAF,
    SELECTED_FOCUSED_LEAF,
    NODE,
    NODE_WITH_CHILDREN,
    SELECTED_NODE,
    SELECTED_NODE_WITH_CHILDREN;

    private static Map<Object[][], SimpleTreeCellRendererState> stateMap;

    private static Map<Object[][], SimpleTreeCellRendererState> getStateMap() {
        if (stateMap == null) {
            stateMap = new LinkedHashMap<Object[][], SimpleTreeCellRendererState>();
            stateMap.put(SimpleTreeCellRendererState.getKey(false, false, false), NODE);
            stateMap.put(SimpleTreeCellRendererState.getKey(false, false, true), NODE_WITH_CHILDREN);
            stateMap.put(SimpleTreeCellRendererState.getKey(false, true, false), SELECTED_NODE);
            stateMap.put(SimpleTreeCellRendererState.getKey(false, true, true), SELECTED_NODE_WITH_CHILDREN);
            stateMap.put(SimpleTreeCellRendererState.getKey(true, false, false), LEAF);
            stateMap.put(SimpleTreeCellRendererState.getKey(true, false, true), LEAF);
            stateMap.put(SimpleTreeCellRendererState.getKey(true, true, false), SELECTED_LEAF);
            stateMap.put(SimpleTreeCellRendererState.getKey(true, true, true), SELECTED_LEAF);
        }
        return stateMap;
    }

    private static Object[][] getKey(boolean leaf, boolean selected, boolean children) {
        Object[][] currentStateArray = new Object[][]{{"leaf", leaf}, {"selected", selected}, {"children", children}};
        return currentStateArray;
    }

    public static SimpleTreeCellRendererState getRenderState(boolean leaf, boolean selected, boolean children) {
        Object[][] currentKey = SimpleTreeCellRendererState.getKey(leaf, selected, children);
        Map<Object[][], SimpleTreeCellRendererState> stateMap = SimpleTreeCellRendererState.getStateMap();
        SimpleTreeCellRendererState currentState = null;
        for (Object[][] key : stateMap.keySet()) {
            if (!Arrays.deepEquals((Object[])key, (Object[])currentKey)) continue;
            currentState = stateMap.get(key);
            break;
        }
        return currentState;
    }

    public static SimpleTreeCellRendererState getState(boolean leaf, boolean selected, boolean children) {
        if (leaf) {
            if (selected) {
                return SELECTED_LEAF;
            }
            return LEAF;
        }
        if (selected) {
            if (children) {
                return SELECTED_NODE_WITH_CHILDREN;
            }
            return SELECTED_NODE;
        }
        if (children) {
            return NODE_WITH_CHILDREN;
        }
        return NODE;
    }
}

