/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.swing.renderer.tree.renderer.state;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;

public enum TreeCellRendererState {
    LEAF,
    SELECTED_LEAF,
    SELECTED_FOCUSED_LEAF,
    NODE,
    EXPANDED_NODE,
    EXPANDED_SELECTED_NODE,
    EXPANDED_SELECTED_NODE_WITH_CHILDREN,
    EXPANDED_SELECTED_FOCUSED_NODE_WITH_CHILDREN,
    EXPANDED_SELECTED_FOCUSED_NODE,
    NODE_WITH_CHILDREN,
    SELECTED_NODE,
    SELECTED_FOCUSED_NODE,
    SELECTED_NODE_WITH_CHILDREN,
    EXPANDED_NODE_WITH_CHILDREN,
    SELECTED_FOCUSED_NODE_WITH_CHILDREN;

    private static Map<Object[][], TreeCellRendererState> stateMap;

    public static TreeCellRendererState getState(boolean leaf, boolean selected, boolean expanded, boolean hasFocus, boolean children) {
        if (leaf) {
            if (selected) {
                if (hasFocus) {
                    return SELECTED_FOCUSED_LEAF;
                }
                return SELECTED_LEAF;
            }
            return LEAF;
        }
        if (expanded) {
            if (selected) {
                if (hasFocus) {
                    if (children) {
                        return EXPANDED_SELECTED_FOCUSED_NODE_WITH_CHILDREN;
                    }
                    return EXPANDED_SELECTED_FOCUSED_NODE;
                }
                if (children) {
                    return EXPANDED_SELECTED_NODE_WITH_CHILDREN;
                }
                return EXPANDED_SELECTED_NODE;
            }
            if (children) {
                return EXPANDED_NODE_WITH_CHILDREN;
            }
            return EXPANDED_NODE;
        }
        if (selected) {
            if (hasFocus) {
                if (children) {
                    return SELECTED_FOCUSED_NODE_WITH_CHILDREN;
                }
                return SELECTED_FOCUSED_NODE;
            }
            if (children) {
                return SELECTED_NODE_WITH_CHILDREN;
            }
            return SELECTED_NODE;
        }
        if (children) {
            return NODE_WITH_CHILDREN;
        }
        return NODE;
    }

    private static Map<Object[][], TreeCellRendererState> getStateMap() {
        if (stateMap == null) {
            stateMap = new LinkedHashMap<Object[][], TreeCellRendererState>();
            stateMap.put(TreeCellRendererState.getKey(false, false, false, false, false), NODE);
            stateMap.put(TreeCellRendererState.getKey(false, false, false, false, true), NODE_WITH_CHILDREN);
            stateMap.put(TreeCellRendererState.getKey(false, false, false, true, false), NODE);
            stateMap.put(TreeCellRendererState.getKey(false, false, false, true, true), NODE_WITH_CHILDREN);
            stateMap.put(TreeCellRendererState.getKey(false, false, true, false, false), EXPANDED_NODE);
            stateMap.put(TreeCellRendererState.getKey(false, false, true, false, true), EXPANDED_NODE_WITH_CHILDREN);
            stateMap.put(TreeCellRendererState.getKey(false, false, true, true, false), EXPANDED_NODE);
            stateMap.put(TreeCellRendererState.getKey(false, false, true, true, true), EXPANDED_NODE_WITH_CHILDREN);
            stateMap.put(TreeCellRendererState.getKey(false, true, false, false, false), SELECTED_NODE);
            stateMap.put(TreeCellRendererState.getKey(false, true, false, false, true), SELECTED_NODE_WITH_CHILDREN);
            stateMap.put(TreeCellRendererState.getKey(false, true, false, true, false), SELECTED_FOCUSED_NODE);
            stateMap.put(TreeCellRendererState.getKey(false, true, false, true, true), SELECTED_FOCUSED_NODE_WITH_CHILDREN);
            stateMap.put(TreeCellRendererState.getKey(false, true, true, false, false), EXPANDED_SELECTED_NODE);
            stateMap.put(TreeCellRendererState.getKey(false, true, true, false, true), EXPANDED_SELECTED_NODE_WITH_CHILDREN);
            stateMap.put(TreeCellRendererState.getKey(false, true, true, true, false), EXPANDED_SELECTED_FOCUSED_NODE);
            stateMap.put(TreeCellRendererState.getKey(false, true, true, true, true), EXPANDED_SELECTED_FOCUSED_NODE_WITH_CHILDREN);
            stateMap.put(TreeCellRendererState.getKey(true, false, false, false, false), LEAF);
            stateMap.put(TreeCellRendererState.getKey(true, false, false, false, true), LEAF);
            stateMap.put(TreeCellRendererState.getKey(true, false, false, true, false), LEAF);
            stateMap.put(TreeCellRendererState.getKey(true, false, false, true, true), LEAF);
            stateMap.put(TreeCellRendererState.getKey(true, false, true, false, false), LEAF);
            stateMap.put(TreeCellRendererState.getKey(true, false, true, false, true), LEAF);
            stateMap.put(TreeCellRendererState.getKey(true, false, true, true, false), LEAF);
            stateMap.put(TreeCellRendererState.getKey(true, false, true, true, true), LEAF);
            stateMap.put(TreeCellRendererState.getKey(true, true, false, false, false), SELECTED_LEAF);
            stateMap.put(TreeCellRendererState.getKey(true, true, false, false, true), SELECTED_LEAF);
            stateMap.put(TreeCellRendererState.getKey(true, true, false, true, false), SELECTED_FOCUSED_LEAF);
            stateMap.put(TreeCellRendererState.getKey(true, true, false, true, true), SELECTED_FOCUSED_LEAF);
            stateMap.put(TreeCellRendererState.getKey(true, true, true, false, false), SELECTED_LEAF);
            stateMap.put(TreeCellRendererState.getKey(true, true, true, false, true), SELECTED_LEAF);
            stateMap.put(TreeCellRendererState.getKey(true, true, true, true, false), SELECTED_FOCUSED_LEAF);
            stateMap.put(TreeCellRendererState.getKey(true, true, true, true, true), SELECTED_FOCUSED_LEAF);
        }
        return stateMap;
    }

    private static Object[][] getKey(boolean leaf, boolean selected, boolean expanded, boolean hasFocus, boolean children) {
        Object[][] currentStateArray = new Object[][]{{"leaf", leaf}, {"selected", selected}, {"expanded", expanded}, {"hasFocus", hasFocus}, {"children", children}};
        return currentStateArray;
    }

    public static TreeCellRendererState getRenderState(boolean leaf, boolean selected, boolean expanded, boolean hasFocus, boolean children) {
        Object[][] currentKey = TreeCellRendererState.getKey(leaf, selected, expanded, hasFocus, children);
        Map<Object[][], TreeCellRendererState> stateMap = TreeCellRendererState.getStateMap();
        TreeCellRendererState currentState = null;
        for (Object[][] key : stateMap.keySet()) {
            if (!Arrays.deepEquals((Object[])key, (Object[])currentKey)) continue;
            currentState = stateMap.get(key);
            break;
        }
        return currentState;
    }
}

