/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.test.object;

import io.github.astrapi69.test.object.Person;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;

public class Employee
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String id;
    private Person person;
    private Set<Employee> subOrdinates;

    public Employee(String id, Person person, Set<Employee> subOrdinates) {
        this.id = id;
        this.person = person;
        this.subOrdinates = subOrdinates;
    }

    public Employee() {
    }

    protected Employee(EmployeeBuilder<?, ?> b) {
        Set<Object> subOrdinates;
        this.id = b.id;
        this.person = b.person;
        switch (b.subOrdinates == null ? 0 : b.subOrdinates.size()) {
            case 0: {
                subOrdinates = Collections.emptySet();
                break;
            }
            case 1: {
                subOrdinates = Collections.singleton(b.subOrdinates.get(0));
                break;
            }
            default: {
                subOrdinates = new LinkedHashSet(b.subOrdinates.size() < 0x40000000 ? 1 + b.subOrdinates.size() + (b.subOrdinates.size() - 3) / 3 : Integer.MAX_VALUE);
                subOrdinates.addAll(b.subOrdinates);
                subOrdinates = Collections.unmodifiableSet(subOrdinates);
            }
        }
        this.subOrdinates = subOrdinates;
    }

    public static EmployeeBuilder<?, ?> builder() {
        return new EmployeeBuilderImpl();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Person getPerson() {
        return this.person;
    }

    public void setPerson(Person person) {
        this.person = person;
    }

    public Set<Employee> getSubOrdinates() {
        return this.subOrdinates;
    }

    public void setSubOrdinates(Set<Employee> subOrdinates) {
        this.subOrdinates = subOrdinates;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Employee)) {
            return false;
        }
        Employee other = (Employee)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        Person this$person = this.getPerson();
        Person other$person = other.getPerson();
        if (this$person == null ? other$person != null : !((Object)this$person).equals(other$person)) {
            return false;
        }
        Set<Employee> this$subOrdinates = this.getSubOrdinates();
        Set<Employee> other$subOrdinates = other.getSubOrdinates();
        return !(this$subOrdinates == null ? other$subOrdinates != null : !((Object)this$subOrdinates).equals(other$subOrdinates));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Employee;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        Person $person = this.getPerson();
        result = result * 59 + ($person == null ? 43 : ((Object)$person).hashCode());
        Set<Employee> $subOrdinates = this.getSubOrdinates();
        result = result * 59 + ($subOrdinates == null ? 43 : ((Object)$subOrdinates).hashCode());
        return result;
    }

    public String toString() {
        return "Employee(id=" + this.getId() + ", person=" + this.getPerson() + ", subOrdinates=" + this.getSubOrdinates() + ")";
    }

    public EmployeeBuilder<?, ?> toBuilder() {
        return new EmployeeBuilderImpl().$fillValuesFrom(this);
    }

    public static abstract class EmployeeBuilder<C extends Employee, B extends EmployeeBuilder<C, B>> {
        private String id;
        private Person person;
        private ArrayList<Employee> subOrdinates;

        private static void $fillValuesFromInstanceIntoBuilder(Employee instance, EmployeeBuilder<?, ?> b) {
            b.id(instance.id);
            b.person(instance.person);
            b.subOrdinates(instance.subOrdinates == null ? Collections.emptySet() : instance.subOrdinates);
        }

        public B id(String id) {
            this.id = id;
            return this.self();
        }

        public B person(Person person) {
            this.person = person;
            return this.self();
        }

        public B subOrdinate(Employee subOrdinate) {
            if (this.subOrdinates == null) {
                this.subOrdinates = new ArrayList();
            }
            this.subOrdinates.add(subOrdinate);
            return this.self();
        }

        public B subOrdinates(Collection<? extends Employee> subOrdinates) {
            if (this.subOrdinates == null) {
                this.subOrdinates = new ArrayList();
            }
            this.subOrdinates.addAll(subOrdinates);
            return this.self();
        }

        public B clearSubOrdinates() {
            if (this.subOrdinates != null) {
                this.subOrdinates.clear();
            }
            return this.self();
        }

        protected B $fillValuesFrom(C instance) {
            EmployeeBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return this.self();
        }

        protected abstract B self();

        public abstract C build();

        public String toString() {
            return "Employee.EmployeeBuilder(id=" + this.id + ", person=" + this.person + ", subOrdinates=" + this.subOrdinates + ")";
        }
    }

    private static final class EmployeeBuilderImpl
    extends EmployeeBuilder<Employee, EmployeeBuilderImpl> {
        private EmployeeBuilderImpl() {
        }

        @Override
        protected EmployeeBuilderImpl self() {
            return this;
        }

        @Override
        public Employee build() {
            return new Employee(this);
        }
    }
}

