/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.test.object;

import io.github.astrapi69.test.object.Company;
import io.github.astrapi69.test.object.Employee;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class Factory
extends Company {
    private static final long serialVersionUID = 1L;
    private List<Employee> employees;
    private Employee ceo;

    public Factory(List<Employee> employees, Employee ceo) {
        this.employees = employees;
        this.ceo = ceo;
    }

    public Factory() {
    }

    protected Factory(FactoryBuilder<?, ?> b) {
        super(b);
        this.employees = switch (b.employees == null ? 0 : b.employees.size()) {
            case 0 -> Collections.emptyList();
            case 1 -> Collections.singletonList(b.employees.get(0));
            default -> Collections.unmodifiableList(new ArrayList<Employee>(b.employees));
        };
        this.ceo = b.ceo;
    }

    public static FactoryBuilder<?, ?> builder() {
        return new FactoryBuilderImpl();
    }

    public List<Employee> getEmployees() {
        return this.employees;
    }

    public void setEmployees(List<Employee> employees) {
        this.employees = employees;
    }

    public Employee getCeo() {
        return this.ceo;
    }

    public void setCeo(Employee ceo) {
        this.ceo = ceo;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Factory)) {
            return false;
        }
        Factory other = (Factory)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<Employee> this$employees = this.getEmployees();
        List<Employee> other$employees = other.getEmployees();
        if (this$employees == null ? other$employees != null : !((Object)this$employees).equals(other$employees)) {
            return false;
        }
        Employee this$ceo = this.getCeo();
        Employee other$ceo = other.getCeo();
        return this$ceo == null ? other$ceo == null : ((Object)this$ceo).equals(other$ceo);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof Factory;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<Employee> $employees = this.getEmployees();
        result = result * 59 + ($employees == null ? 43 : ((Object)$employees).hashCode());
        Employee $ceo = this.getCeo();
        result = result * 59 + ($ceo == null ? 43 : ((Object)$ceo).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "Factory(employees=" + this.getEmployees() + ", ceo=" + this.getCeo() + ")";
    }

    public FactoryBuilder<?, ?> toBuilder() {
        return new FactoryBuilderImpl().$fillValuesFrom(this);
    }

    public static abstract class FactoryBuilder<C extends Factory, B extends FactoryBuilder<C, B>>
    extends Company.CompanyBuilder<C, B> {
        private ArrayList<Employee> employees;
        private Employee ceo;

        private static void $fillValuesFromInstanceIntoBuilder(Factory instance, FactoryBuilder<?, ?> b) {
            b.employees(instance.employees == null ? Collections.emptyList() : instance.employees);
            b.ceo(instance.ceo);
        }

        public B employee(Employee employee) {
            if (this.employees == null) {
                this.employees = new ArrayList();
            }
            this.employees.add(employee);
            return (B)this.self();
        }

        public B employees(Collection<? extends Employee> employees) {
            if (this.employees == null) {
                this.employees = new ArrayList();
            }
            this.employees.addAll(employees);
            return (B)this.self();
        }

        public B clearEmployees() {
            if (this.employees != null) {
                this.employees.clear();
            }
            return (B)this.self();
        }

        public B ceo(Employee ceo) {
            this.ceo = ceo;
            return (B)this.self();
        }

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            FactoryBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "Factory.FactoryBuilder(super=" + super.toString() + ", employees=" + this.employees + ", ceo=" + this.ceo + ")";
        }
    }

    private static final class FactoryBuilderImpl
    extends FactoryBuilder<Factory, FactoryBuilderImpl> {
        private FactoryBuilderImpl() {
        }

        @Override
        protected FactoryBuilderImpl self() {
            return this;
        }

        @Override
        public Factory build() {
            return new Factory(this);
        }
    }
}

