/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.test.object.factory;

import io.github.astrapi69.test.object.A;
import io.github.astrapi69.test.object.AlgorithmModel;
import io.github.astrapi69.test.object.ApplicationTestModel;
import io.github.astrapi69.test.object.ClonableObject;
import io.github.astrapi69.test.object.Club;
import io.github.astrapi69.test.object.Company;
import io.github.astrapi69.test.object.CompanyGroup;
import io.github.astrapi69.test.object.Customer;
import io.github.astrapi69.test.object.Employee;
import io.github.astrapi69.test.object.EmployeeList;
import io.github.astrapi69.test.object.Factory;
import io.github.astrapi69.test.object.Light;
import io.github.astrapi69.test.object.Member;
import io.github.astrapi69.test.object.NotSerializable;
import io.github.astrapi69.test.object.Permission;
import io.github.astrapi69.test.object.Person;
import io.github.astrapi69.test.object.PremiumMember;
import io.github.astrapi69.test.object.PrimitiveArrays;
import io.github.astrapi69.test.object.PrimitiveObjectClassArrays;
import io.github.astrapi69.test.object.SingletonBean;
import io.github.astrapi69.test.object.Television;
import io.github.astrapi69.test.object.enumeration.Brand;
import io.github.astrapi69.test.object.enumeration.Gender;
import io.github.astrapi69.test.object.factory.TestAuthFactory;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class TestObjectFactory {
    public static A newA() {
        return A.builder().a("a").build();
    }

    public static AlgorithmModel newAlgorithmModel() {
        return AlgorithmModel.builder().a(1).b(2).build();
    }

    public static <T> ApplicationTestModel<T> newApplicationTestModel(T model) {
        return ApplicationTestModel.builder().model(model).build();
    }

    public static ClonableObject newClonableObject() {
        return ClonableObject.builder().name("me").build();
    }

    public static Club newClub() {
        return ((Club.ClubBuilder)((Club.ClubBuilder)((Club.ClubBuilder)((Club.ClubBuilder)Club.builder().member(Member.buildMember().name("Lea").gender(Gender.FEMALE).married(Boolean.FALSE).nickname("princess").build())).member(Member.buildMember().name("Luke").gender(Gender.MALE).married(Boolean.FALSE).nickname("wannabejedi").build())).name("StarPiece")).location("Greece/Katerini")).build();
    }

    public static Company newCompany() {
        return ((Company.CompanyBuilder)((Company.CompanyBuilder)Company.builder().name("factory-forte")).location("Earth")).build();
    }

    public static CompanyGroup newCompanyGroup() {
        HashSet<Company> children = new HashSet<Company>();
        children.add((Company)((Company.CompanyBuilder)((Company.CompanyBuilder)Company.builder().name("factory-Mars")).location("Jupiter")).build());
        return ((CompanyGroup.CompanyGroupBuilder)((CompanyGroup.CompanyGroupBuilder)CompanyGroup.builder().parent(TestObjectFactory.newFactory())).children(children)).build();
    }

    public static Customer newCustomer() {
        return Customer.builder().name("charlie").car(Brand.FERRARI).premium(true).build();
    }

    public static Employee newEmployee() {
        return ((Employee.EmployeeBuilder)((Employee.EmployeeBuilder)Employee.builder().id("1")).person(Person.builder().name("Lea").gender(Gender.FEMALE).married(Boolean.FALSE).build())).build();
    }

    public static EmployeeList newEmployeeList() {
        return EmployeeList.builder().employee(TestObjectFactory.newEmployee()).employee((Employee)((Employee.EmployeeBuilder)((Employee.EmployeeBuilder)Employee.builder().id("2")).person(Person.builder().name("Luke").gender(Gender.MALE).married(Boolean.FALSE).build())).build()).build();
    }

    public static Factory newFactory() {
        return ((Factory.FactoryBuilder)((Factory.FactoryBuilder)((Company.CompanyBuilder)((Factory.FactoryBuilder)Factory.builder().employee(TestObjectFactory.newEmployee())).employee((Employee)((Employee.EmployeeBuilder)((Employee.EmployeeBuilder)Employee.builder().id("2")).person(Person.builder().name("Luke").gender(Gender.MALE).married(Boolean.FALSE).build())).build())).name("StarPiece")).location("Greece/Katerini")).build();
    }

    public static Light newLight() {
        return Light.builder().on(true).build();
    }

    public static Member newMember() {
        Date dateofbirth = Date.from(LocalDate.of(1979, 2, 24).atStartOfDay(ZoneId.of("Europe/Berlin")).toInstant());
        Date dateofMarriage = Date.from(LocalDate.of(2017, 8, 8).atStartOfDay(ZoneId.of("Europe/Berlin")).toInstant());
        return Member.buildMember().dateofbirth(dateofbirth).dateofMarriage(dateofMarriage).gender(Gender.MALE).name("Avano").married(true).about("I'm a silly and ill.").nickname("idiot").build();
    }

    public static NotSerializable newNotSerializable() {
        return NotSerializable.builder().name("Foo").build();
    }

    public static Permission newPermission() {
        return Permission.builder().name("read").description("Can read files").shortcut("r").build();
    }

    public static Person newPerson() {
        return Person.builder().gender(Gender.FEMALE).name("Anna").married(false).about("I'm a beast and beautiful").nickname("beast").build();
    }

    public static PremiumMember newPremiumMember() {
        Date dateofbirth = Date.from(LocalDate.of(1979, 2, 24).atStartOfDay(ZoneId.of("Europe/Berlin")).toInstant());
        Date dateofMarriage = Date.from(LocalDate.of(2017, 8, 8).atStartOfDay(ZoneId.of("Europe/Berlin")).toInstant());
        return PremiumMember.buildPremiumMember().dateofbirth(dateofbirth).dateofMarriage(dateofMarriage).gender(Gender.MALE).name("Avano").married(true).about("I'm a silly and ill.").nickname("idiot").credits("-10000000000,-Diamonds").build();
    }

    public static PrimitiveArrays newPrimitiveArrays() {
        return ((PrimitiveArrays.PrimitivesArraysBuilder)((PrimitiveArrays.PrimitivesArraysBuilder)((PrimitiveArrays.PrimitivesArraysBuilder)((PrimitiveArrays.PrimitivesArraysBuilder)((PrimitiveArrays.PrimitivesArraysBuilder)((PrimitiveArrays.PrimitivesArraysBuilder)((PrimitiveArrays.PrimitivesArraysBuilder)((PrimitiveArrays.PrimitivesArraysBuilder)PrimitiveArrays.builder().booleanArray(new boolean[]{true, false, false})).byteArray(new byte[]{2, 4, 5})).charArray(new char[]{'a', 'c', 'd'})).shortArray(new short[]{1, 3, 6})).intArray(new int[]{7, 8, 0})).longArray(new long[]{9L, 10L, 11L})).floatArray(new float[]{12.1f, 14.3f, 15.6f})).doubleArray(new double[]{17.3, 19.6, 21.0})).build();
    }

    public static PrimitiveObjectClassArrays newPrimitiveObjectClassArrays() {
        return ((PrimitiveObjectClassArrays.PrimitiveObjectClassArraysBuilder)((PrimitiveObjectClassArrays.PrimitiveObjectClassArraysBuilder)((PrimitiveObjectClassArrays.PrimitiveObjectClassArraysBuilder)((PrimitiveObjectClassArrays.PrimitiveObjectClassArraysBuilder)((PrimitiveObjectClassArrays.PrimitiveObjectClassArraysBuilder)((PrimitiveObjectClassArrays.PrimitiveObjectClassArraysBuilder)((PrimitiveObjectClassArrays.PrimitiveObjectClassArraysBuilder)((PrimitiveObjectClassArrays.PrimitiveObjectClassArraysBuilder)PrimitiveObjectClassArrays.builder().booleanArray(new Boolean[]{true, false, false})).byteArray(new Byte[]{(byte)2, (byte)4, (byte)5})).charArray(new Character[]{Character.valueOf('a'), Character.valueOf('c'), Character.valueOf('d')})).shortArray(new Short[]{(short)1, (short)3, (short)6})).intArray(new Integer[]{7, 8, 0})).longArray(new Long[]{9L, 10L, 11L})).floatArray(new Float[]{Float.valueOf(12.1f), Float.valueOf(14.3f), Float.valueOf(15.6f)})).doubleArray(new Double[]{17.3, 19.6, 21.0})).build();
    }

    public static SingletonBean newSingletonBean() {
        return SingletonBean.getInstance();
    }

    public static Television newTelevision() {
        return Television.builder().on(true).channel(1).build();
    }

    public static Map<String, Object> getAllTestObjectsInMap() {
        LinkedHashMap<String, Object> allTestObjects = new LinkedHashMap<String, Object>();
        for (Object object : TestObjectFactory.getAllTestObjects()) {
            String name = object.getClass().getCanonicalName();
            allTestObjects.put(name, object);
        }
        return allTestObjects;
    }

    public static List<Object> getAllTestObjects() {
        ArrayList<Object> allTestObjects = new ArrayList<Object>();
        allTestObjects.add(TestObjectFactory.newA());
        allTestObjects.add(TestObjectFactory.newAlgorithmModel());
        allTestObjects.add(TestObjectFactory.newApplicationTestModel(TestObjectFactory.newA()));
        allTestObjects.add(TestObjectFactory.newClonableObject());
        allTestObjects.add(TestObjectFactory.newClub());
        allTestObjects.add(TestObjectFactory.newCompany());
        allTestObjects.add(TestObjectFactory.newCompanyGroup());
        allTestObjects.add(TestObjectFactory.newCustomer());
        allTestObjects.add(TestObjectFactory.newEmployee());
        allTestObjects.add(TestObjectFactory.newEmployeeList());
        allTestObjects.add(TestObjectFactory.newFactory());
        allTestObjects.add(TestObjectFactory.newLight());
        allTestObjects.add(TestObjectFactory.newMember());
        allTestObjects.add(TestObjectFactory.newNotSerializable());
        allTestObjects.add(TestObjectFactory.newPermission());
        allTestObjects.add(TestObjectFactory.newPerson());
        allTestObjects.add(TestObjectFactory.newPremiumMember());
        allTestObjects.add(TestObjectFactory.newPrimitiveArrays());
        allTestObjects.add(TestObjectFactory.newPrimitiveObjectClassArrays());
        allTestObjects.add(TestObjectFactory.newSingletonBean().setPerson(TestObjectFactory.newPerson()));
        allTestObjects.add(TestObjectFactory.newTelevision());
        allTestObjects.add(TestAuthFactory.newAccessRight());
        allTestObjects.add(TestAuthFactory.newRole());
        allTestObjects.add(TestAuthFactory.newRoles());
        allTestObjects.add(TestAuthFactory.newSignin());
        return allTestObjects;
    }
}

