/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.test.object.type.hierarchy.shape;

import io.github.astrapi69.test.object.type.hierarchy.shape.Shape;

public class Circle
implements Shape {
    private double radius;

    public Circle(double radius) {
        this.radius = radius;
    }

    public Circle() {
    }

    public static CircleBuilder builder() {
        return new CircleBuilder();
    }

    @Override
    public double calculateArea() {
        return 3.14 * this.radius * this.radius;
    }

    public double getRadius() {
        return this.radius;
    }

    public void setRadius(double radius) {
        this.radius = radius;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Circle)) {
            return false;
        }
        Circle other = (Circle)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return Double.compare(this.getRadius(), other.getRadius()) == 0;
    }

    protected boolean canEqual(Object other) {
        return other instanceof Circle;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $radius = Double.doubleToLongBits(this.getRadius());
        result = result * 59 + (int)($radius >>> 32 ^ $radius);
        return result;
    }

    public String toString() {
        return "Circle(radius=" + this.getRadius() + ")";
    }

    public static class CircleBuilder {
        private double radius;

        CircleBuilder() {
        }

        public CircleBuilder radius(double radius) {
            this.radius = radius;
            return this;
        }

        public Circle build() {
            return new Circle(this.radius);
        }

        public String toString() {
            return "Circle.CircleBuilder(radius=" + this.radius + ")";
        }
    }
}

