/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.test.object.type.hierarchy.shape;

import io.github.astrapi69.test.object.type.hierarchy.shape.Shape;

public class Rectangle
implements Shape {
    private double height;
    private double width;

    public Rectangle(double height, double width) {
        this.height = height;
        this.width = width;
    }

    public Rectangle() {
    }

    public static RectangleBuilder builder() {
        return new RectangleBuilder();
    }

    @Override
    public double calculateArea() {
        return this.height * this.width;
    }

    public double getHeight() {
        return this.height;
    }

    public void setHeight(double height) {
        this.height = height;
    }

    public double getWidth() {
        return this.width;
    }

    public void setWidth(double width) {
        this.width = width;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Rectangle)) {
            return false;
        }
        Rectangle other = (Rectangle)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getHeight(), other.getHeight()) != 0) {
            return false;
        }
        return Double.compare(this.getWidth(), other.getWidth()) == 0;
    }

    protected boolean canEqual(Object other) {
        return other instanceof Rectangle;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $height = Double.doubleToLongBits(this.getHeight());
        result = result * 59 + (int)($height >>> 32 ^ $height);
        long $width = Double.doubleToLongBits(this.getWidth());
        result = result * 59 + (int)($width >>> 32 ^ $width);
        return result;
    }

    public String toString() {
        return "Rectangle(height=" + this.getHeight() + ", width=" + this.getWidth() + ")";
    }

    public static class RectangleBuilder {
        private double height;
        private double width;

        RectangleBuilder() {
        }

        public RectangleBuilder height(double height) {
            this.height = height;
            return this;
        }

        public RectangleBuilder width(double width) {
            this.width = width;
            return this;
        }

        public Rectangle build() {
            return new Rectangle(this.height, this.width);
        }

        public String toString() {
            return "Rectangle.RectangleBuilder(height=" + this.height + ", width=" + this.width + ")";
        }
    }
}

