/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.test.object.type.hierarchy.shape;

import io.github.astrapi69.test.object.type.hierarchy.shape.Shape;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class ShapeStore {
    private List<Shape> shapes;

    public ShapeStore(List<Shape> shapes) {
        this.shapes = shapes;
    }

    public ShapeStore() {
    }

    public static ShapeStoreBuilder builder() {
        return new ShapeStoreBuilder();
    }

    public void add(Shape shape) {
        this.shapes.add(shape);
    }

    public void remove(Shape shape) {
        this.shapes.remove(shape);
    }

    public List<Shape> getShapes() {
        return this.shapes;
    }

    public void setShapes(List<Shape> shapes) {
        this.shapes = shapes;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ShapeStore)) {
            return false;
        }
        ShapeStore other = (ShapeStore)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<Shape> this$shapes = this.getShapes();
        List<Shape> other$shapes = other.getShapes();
        return !(this$shapes == null ? other$shapes != null : !((Object)this$shapes).equals(other$shapes));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ShapeStore;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<Shape> $shapes = this.getShapes();
        result = result * 59 + ($shapes == null ? 43 : ((Object)$shapes).hashCode());
        return result;
    }

    public String toString() {
        return "ShapeStore(shapes=" + this.getShapes() + ")";
    }

    public static class ShapeStoreBuilder {
        private ArrayList<Shape> shapes;

        ShapeStoreBuilder() {
        }

        public ShapeStoreBuilder shape(Shape shape) {
            if (this.shapes == null) {
                this.shapes = new ArrayList();
            }
            this.shapes.add(shape);
            return this;
        }

        public ShapeStoreBuilder shapes(Collection<? extends Shape> shapes) {
            if (this.shapes == null) {
                this.shapes = new ArrayList();
            }
            this.shapes.addAll(shapes);
            return this;
        }

        public ShapeStoreBuilder clearShapes() {
            if (this.shapes != null) {
                this.shapes.clear();
            }
            return this;
        }

        public ShapeStore build() {
            return new ShapeStore(switch (this.shapes == null ? 0 : this.shapes.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this.shapes.get(0));
                default -> Collections.unmodifiableList(new ArrayList<Shape>(this.shapes));
            });
        }

        public String toString() {
            return "ShapeStore.ShapeStoreBuilder(shapes=" + this.shapes + ")";
        }
    }
}

