/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.throwable;

import io.github.astrapi69.throwable.api.RuntimeExceptionDecoratable;
import io.github.astrapi69.throwable.api.ThrowableConsumer;
import io.github.astrapi69.throwable.api.ThrowableNoArgumentConsumer;
import java.util.function.Consumer;

public class RuntimeExceptionDecorator {
    public static <T> T decorate(RuntimeExceptionDecoratable<T> decoratable) {
        try {
            return decoratable.execute();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static <T, E extends Throwable> Consumer<T> decorate(ThrowableConsumer<T, E> throwableConsumer) {
        return object -> {
            try {
                throwableConsumer.accept(object);
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
        };
    }

    public static <T extends Throwable> ThrowableNoArgumentConsumer<T> decorate(ThrowableNoArgumentConsumer<T> noArgumentConsumer) {
        ThrowableNoArgumentConsumer throwableNoArgumentConsumer;
        try {
            throwableNoArgumentConsumer = () -> noArgumentConsumer.accept();
            throwableNoArgumentConsumer.accept();
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
        return throwableNoArgumentConsumer;
    }
}

