/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.throwable;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collectors;

public final class ThrowableExtensions {
    private ThrowableExtensions() {
    }

    public static String getStackTrace(Throwable throwable, String ... additionalInfos) {
        Objects.requireNonNull(throwable);
        StringBuilder stacktrace = ThrowableExtensions.getAdditionalInfos(additionalInfos);
        StringWriter stringWriter = new StringWriter();
        try (PrintWriter pw = new PrintWriter(stringWriter);){
            throwable.printStackTrace(pw);
            stacktrace.append(stringWriter);
        }
        return stacktrace.toString();
    }

    public static String getStackTraceElements(Throwable throwable, String ... additionalInfos) {
        Objects.requireNonNull(throwable);
        StringBuilder stacktrace = ThrowableExtensions.getAdditionalInfos(additionalInfos);
        StringWriter stringWriter = new StringWriter();
        try (PrintWriter pw = new PrintWriter(stringWriter);){
            pw.println(throwable.getClass().toString());
            while (throwable != null) {
                StackTraceElement[] stackTraceElements;
                pw.println(throwable);
                for (StackTraceElement stackTraceElement : stackTraceElements = throwable.getStackTrace()) {
                    pw.println("\tat " + stackTraceElement);
                }
                throwable = throwable.getCause();
            }
            stacktrace.append(stringWriter.toString());
        }
        return stacktrace.toString();
    }

    private static StringBuilder getAdditionalInfos(String ... additionalInfos) {
        return ThrowableExtensions.getAdditionalInfos(", ", additionalInfos);
    }

    private static StringBuilder getAdditionalInfos(String delimiter, String ... additionalInfos) {
        StringBuilder stacktrace = new StringBuilder();
        if (0 < additionalInfos.length) {
            stacktrace.append(Arrays.stream(additionalInfos).filter(Objects::nonNull).map(Object::toString).collect(Collectors.joining(delimiter)));
            stacktrace.append(" ");
        }
        return stacktrace;
    }

    public static String newThrowableMessage(Throwable throwable, String additionalInfo) {
        Objects.requireNonNull(throwable);
        return additionalInfo + " [" + throwable.getClass().getSimpleName() + "]: " + Objects.toString(throwable.getMessage(), "empty message");
    }
}

