/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.xml;

import io.github.astrapi69.file.read.ReadFileExtensions;
import io.github.astrapi69.lang.ClassExtensions;
import io.github.astrapi69.xml.jackson.XmlToObjectExtensions;
import io.github.astrapi69.xml.parser.DocumentExtensions;
import io.github.astrapi69.xml.parser.DocumentFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.Map;
import java.util.Objects;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.commons.io.FileUtils;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class XmlExtensions {
    private XmlExtensions() {
    }

    public static InputSource getInputSource(String xmlString) {
        return new InputSource(new StringReader(xmlString));
    }

    public static <T> T loadObject(File xmlFile) throws IOException {
        FileInputStream is = FileUtils.openInputStream((File)xmlFile);
        return XmlExtensions.loadObject(is);
    }

    public static <T> T loadObject(File xmlFile, Class<T> clazz) throws IOException {
        Objects.requireNonNull(clazz);
        FileInputStream is = FileUtils.openInputStream((File)xmlFile);
        return XmlExtensions.loadObject(is, clazz);
    }

    public static String prettyPrint(String xmlString) throws ParserConfigurationException, IOException, SAXException, TransformerException {
        return XmlExtensions.prettyPrint(xmlString, 4);
    }

    public static String prettyPrint(String xmlString, int indent) throws ParserConfigurationException, IOException, SAXException, TransformerException {
        return DocumentExtensions.toString((Document)DocumentFactory.newDocument((String)xmlString), (int)indent);
    }

    private static <T> T loadObject(InputStream is) throws IOException {
        return (T)io.github.astrapi69.xstream.XmlToObjectExtensions.toObject((String)ReadFileExtensions.inputStream2String((InputStream)is));
    }

    private static <T> T loadObject(InputStream is, Class<T> clazz) throws IOException {
        Objects.requireNonNull(is);
        Objects.requireNonNull(clazz);
        String xmlString = ReadFileExtensions.inputStream2String((InputStream)is);
        return (T)XmlToObjectExtensions.toObject((String)xmlString, clazz);
    }

    public static <T> T loadObject(String xmlFileName) throws IOException {
        InputStream is = ClassExtensions.getResourceAsStream((String)xmlFileName);
        return XmlExtensions.loadObject(is);
    }

    public static <T> T loadObject(String xmlFileName, Class<T> clazz) throws IOException {
        Objects.requireNonNull(clazz);
        InputStream is = ClassExtensions.getResourceAsStream((String)xmlFileName);
        return XmlExtensions.loadObject(is, clazz);
    }

    public static String newTag(String tagname, String value, Map<String, String> attributes) {
        StringBuilder xmlTag = new StringBuilder();
        xmlTag.append("<").append(tagname);
        if (attributes != null && !attributes.isEmpty()) {
            xmlTag.append(" ");
            int count = 1;
            for (Map.Entry<String, String> attributte : attributes.entrySet()) {
                xmlTag.append(attributte.getKey());
                xmlTag.append("=");
                xmlTag.append("\"").append(attributte.getValue()).append("\"");
                if (count != attributes.size()) {
                    xmlTag.append(" ");
                }
                ++count;
            }
        }
        xmlTag.append(">");
        xmlTag.append(value);
        xmlTag.append("</").append(tagname).append(">");
        return xmlTag.toString();
    }
}

