/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.xml.crypto.file;

import com.thoughtworks.xstream.XStream;
import io.github.astrapi69.crypt.data.hex.HexExtensions;
import io.github.astrapi69.file.read.ReadFileExtensions;
import io.github.astrapi69.xstream.XmlToObjectExtensions;
import io.github.astrapi69.xstream.factory.XStreamFactory;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.codec.DecoderException;

public final class XmlDecryptionExtensions {
    private XmlDecryptionExtensions() {
    }

    public static <T> T readFromFileAsXmlAndHex(Map<String, Class<?>> aliases, File selectedFile, String ... allowTypesByWildcard) throws IOException, DecoderException {
        Objects.requireNonNull(aliases);
        Objects.requireNonNull(selectedFile);
        XStream xStream = XStreamFactory.newXStream();
        XStreamFactory.newXStream((XStream)xStream, aliases, (String[])allowTypesByWildcard);
        return XmlDecryptionExtensions.readFromFileAsXmlAndHex(xStream, aliases, selectedFile);
    }

    public static <T> T readFromFileAsXmlAndHex(XStream xstream, Map<String, Class<?>> aliases, File selectedFile) throws IOException, DecoderException {
        Objects.requireNonNull(xstream);
        Objects.requireNonNull(aliases);
        Objects.requireNonNull(selectedFile);
        return XmlDecryptionExtensions.readFromFileAsXmlAndHex(xstream, aliases, selectedFile, "UTF-8");
    }

    public static <T> T readFromFileAsXmlAndHex(XStream xstream, Map<String, Class<?>> aliases, File selectedFile, String charset) throws IOException, DecoderException {
        Objects.requireNonNull(xstream);
        Objects.requireNonNull(aliases);
        Objects.requireNonNull(selectedFile);
        String hexXmlString = ReadFileExtensions.readFromFile((File)selectedFile, (Charset)Charset.forName(charset));
        String xmlString = HexExtensions.decodeHex((String)hexXmlString);
        return (T)XmlToObjectExtensions.toObject((XStream)xstream, (String)xmlString, aliases);
    }
}

