/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.xml.crypto.file;

import com.thoughtworks.xstream.XStream;
import io.github.astrapi69.crypt.data.hex.HexExtensions;
import io.github.astrapi69.file.write.WriteFileExtensions;
import io.github.astrapi69.xstream.ObjectToXmlExtensions;
import io.github.astrapi69.xstream.factory.XStreamFactory;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.Objects;

public final class XmlEncryptionExtensions {
    private XmlEncryptionExtensions() {
    }

    public static <T> void writeToFileAsXmlAndHex(Map<String, Class<?>> aliases, T data, File file, String ... allowTypesByWildcard) throws IOException {
        Objects.requireNonNull(aliases);
        Objects.requireNonNull(data);
        Objects.requireNonNull(file);
        XmlEncryptionExtensions.writeToFileAsXmlAndHex(XStreamFactory.newXStream((XStream)XStreamFactory.newXStream(), aliases, (String[])allowTypesByWildcard), aliases, data, file);
    }

    public static <T> void writeToFileAsXmlAndHex(XStream xstream, Map<String, Class<?>> aliases, T data, File file) throws IOException {
        Objects.requireNonNull(xstream);
        Objects.requireNonNull(aliases);
        Objects.requireNonNull(data);
        Objects.requireNonNull(file);
        XmlEncryptionExtensions.writeToFileAsXmlAndHex(xstream, aliases, data, file, "UTF-8");
    }

    public static <T> void writeToFileAsXmlAndHex(XStream xstream, Map<String, Class<?>> aliases, T data, File file, String charset) throws IOException {
        Objects.requireNonNull(xstream);
        Objects.requireNonNull(aliases);
        Objects.requireNonNull(data);
        Objects.requireNonNull(file);
        String xmlString = ObjectToXmlExtensions.toXml((XStream)xstream, data, aliases);
        String hexXmlString = HexExtensions.encodeHex((String)xmlString, (Charset)Charset.forName(charset), (boolean)true);
        WriteFileExtensions.writeStringToFile((File)file, (String)hexXmlString, (String)charset);
    }
}

