/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.xsl.transform;

import io.github.astrapi69.xml.transform.TransformerFactoryInitializer;
import java.io.File;
import java.io.OutputStream;
import java.util.Objects;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public final class XsltTransformerExtensions {
    private static final TransformerFactory TRANSFORMER_FACTORY = TransformerFactory.newInstance();

    private XsltTransformerExtensions() {
    }

    public static void transform(File xmlFile, File xsltFile, OutputStream outputStream) throws TransformerConfigurationException, TransformerException {
        Objects.requireNonNull(xmlFile);
        Objects.requireNonNull(xsltFile);
        StreamSource xmlSource = new StreamSource(xmlFile);
        StreamSource xsltSource = new StreamSource(xsltFile);
        XsltTransformerExtensions.transform(xmlSource, xsltSource, outputStream);
    }

    public static void transform(Source xmlSource, Source xsltSource, OutputStream outputStream) throws TransformerConfigurationException, TransformerException {
        Transformer transformer = TransformerFactoryInitializer.newTransformer((Source)xsltSource);
        transformer.transform(xmlSource, new StreamResult(outputStream));
    }

    public static void transform(String xmlInputFile, String xsltInputFile, OutputStream outputStream) throws TransformerConfigurationException, TransformerException {
        File xmlFile = new File(xmlInputFile);
        File xsltFile = new File(xsltInputFile);
        XsltTransformerExtensions.transform(xmlFile, xsltFile, outputStream);
    }
}

