/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.xml.jackson;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import io.github.astrapi69.throwable.RuntimeExceptionDecorator;
import io.github.astrapi69.xml.jackson.factory.XmlMapperFactory;
import java.io.File;
import java.io.IOException;
import lombok.NonNull;

public final class ObjectToXmlExtensions {
    private ObjectToXmlExtensions() {
    }

    public static <T> String toXml(@NonNull T objectToXML) throws JsonProcessingException {
        if (objectToXML == null) {
            throw new NullPointerException("objectToXML is marked non-null but is null");
        }
        XmlMapper xmlMapper = XmlMapperFactory.newXmlMapper();
        return xmlMapper.writerWithDefaultPrettyPrinter().writeValueAsString(objectToXML);
    }

    public static <T> void toXml(@NonNull T object, @NonNull File file) {
        if (object == null) {
            throw new NullPointerException("object is marked non-null but is null");
        }
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        XmlMapper xmlMapper = XmlMapperFactory.newXmlMapper();
        RuntimeExceptionDecorator.decorate(() -> ObjectToXmlExtensions.lambda$toXml$0((ObjectMapper)xmlMapper, file, object));
    }

    private static /* synthetic */ void lambda$toXml$0(ObjectMapper xmlMapper, File file, Object object) throws IOException {
        xmlMapper.writerWithDefaultPrettyPrinter().writeValue(file, object);
    }
}

